import time
import logging

class Timer(object):
    
    def __init__(self, print_results: bool) -> None:
        self.cur_time = time.time()
        self.print_results = print_results

    def snap(self, message=None, force_print=False) -> None:
        if self.print_results or force_print:
            if message:
                logging.info(message + "|| Time elapsed: " + str(round(time.time() - self.cur_time, 2)))

            self.cur_time = time.time()