SIZE=small

# If no arguments are passed uuid is set to a random uuid.
if [ $# -eq 0 ]; then
    uuid=$(uuidgen)
else
    uuid=$1
    wandb=$2
fi

host_name=$(hostname)
WORKING_DIR="/mnt/batch/tasks/shared/LS_root/mounts/clusters/"$host_name"/code/checkpoints/supervised/"$uuid
REGULAR_LOG="/mnt/batch/tasks/shared/LS_root/mounts/clusters/DIRNAME1/code/Users/DIRNAME/addition/logs/supervised_train/"$uuid"_supervisedtrain.log"

echo "Working directory: "$WORKING_DIR
mkdir -p $WORKING_DIR
echo UUID: $uuid >> $WORKING_DIR"/master.log"
echo MASTERLOG: $WORKING_DIR"/master.log" >> $WORKING_DIR"/master.log"
echo REGULARLOG: $REGULAR_LOG >> $WORKING_DIR"/master.log"
echo SIZE: $SIZE >> $WORKING_DIR"/master.log"
echo Git Hash: $(git rev-parse HEAD) >> $WORKING_DIR"/master.log"
code $WORKING_DIR"/master.log"

SEED=0
EXIT=0

# Loop while last command has exit code 0
    # Increment SEED so no repeats
python3 supervised_train.py --type=decomp --uuid=$uuid --size=$SIZE --seed=$SEED --wandb_id=$wandb
