# Exploiting Safe Spots in Neural Networks for Preemptive Robustness and Anomaly Detection

This is the code for the paper "Exploiting Safe Spots in Neural Networks for Preemptive Robustness and Anomaly Detection" submitted to NeurIPS'20.

## Requirments
* python (3.7.4)
* pytorch (1.3.1)
* torchvision (0.4.2)
* CUDA
* Pillow
* numpy
* gdown


## Preparing ImageNet data

- Download the ImageNet dataset from http://www.image-net.org/
- Then, and move validation images to labeled subfolders, using [the following shell script](https://raw.githubusercontent.com/soumith/imagenetloader.torch/master/valprep.sh)

## Preparing TinyImages data
- Download the TinyImages dataset from http://horatio.cs.nyu.edu/mit/tiny/data/tiny_images.bin.
- Create a new subfolder named 'tiny_images' in ```args.data_dir``` and move the downloaded file into the subfolder.

## Preparing SVHN data
- Download the SVHN test dataset from http://ufldl.stanford.edu/housenumbers/test_32x32.mat.
- Create a new subfolder named 'svhn' in ```args.data_dir``` and move the downloaded file into the subfolder.

## Preparing TinyImageNet data
- Download the TinyImageNet dataset from http://cs231n.stanford.edu/tiny-imagenet-200.zip.
- Unzip the downloaded file.
- Move the unzipped folder into ```args.data_dir```.

## Preparing LSUN data
- Download the LSUN test dataset from http://dl.yf.io/lsun/scenes/test_lmdb.zip.
- Unzip the downloaded file.
- Create a new subfolder named 'lsun' in ```args.data_dir``` and move the unzipped folder into the subfolder.

## How to download our checkpoints

Shell scripts for downloading our each models are located in ```src/checkpoints/[dataset]/[model architecture]/[train type]/download.sh```. You can run each script to download a checkpoint named ```ckpt.pt```. To down load all models, run ```download_all.sh```.

## Reproducing the results of preemptive robustness

To reproduce the results from the paper, run ```src/s_full.py``` (for S-full results) or ```src/s_pgd.py``` (for S-FGSM and S-PGD results). Refer to ```src/arguments.py``` for detailed descriptions of arguments. Below are some of the examples for reproducing the results.

To reproduce the S-Full results on CIFAR-10, l_inf for PGD adversarially trained model, run:
```bash
python src/s_full.py --data_type CIFAR10 --data_dir [CIFAR-10 data folder] --model_type WideResNet --train_type adv_linf --eval --defense_type SafeSpotLinf --delta 0.031 --num_iters 100 --lr 0.1 --attack_type PGDAttackLinf --epsilon 0.031 --num_steps 20 --step_size 0.00775 --random_starts 1 --attack_type_test PGDAttackLinf --epsilon_test 0.031 --num_steps_test 20 --step_size_test 0.00775 --batch_size 100 --num_images 1000
```

To reproduce the S-PGD results on CIFAR-10, l_inf for PGD adversarially trained model, run:
```bash
python src/s_pgd.py --data_type CIFAR10 --data_dir [CIFAR-10 data folder] --model_type WideResNet --train_type adv_linf --eval --defense_type PGDAttackLinf --delta 0.031 --num_iters 20 --lr 0.00775 --attack_type PGDAttackLinf --epsilon 0.031 --num_steps 20 --step_size 0.00775 --random_starts 1 --attack_type_test PGDAttackLinf --epsilon_test 0.031 --num_steps_test 20 --step_size_test 0.00775 --batch_size 100 --num_images 1000
```

To reproduce the S-Full results on CIFAR-10, l_2 for naturally trained model with randomized smoothing, run:
```bash
python src/s_full.py --data_type CIFAR10 --data_dir [CIFAR-10 data folder] --model_type WideResNet --train_type nat --eval_rand --scale 0.05 --defense_type SafeSpotL2Rand --delta 0.5 --num_iters 100 --lr 1e-3 --attack_type PGDAttackL2Rand --epsilon 0.5 --num_steps 20 --step_size 0.125 --random_starts 1 --num_samples 5 --attack_type_test PGDAttackL2Rand --epsilon_test 0.5 --num_steps_test 20 --step_size_test 0.125 --num_samples_test 50 --batch_size 1 --num_images 1000
```

To reproduce the S-Full results on ImageNet, l_2 for naturally trained model, run:
```bash
python src/s_full.py --data_type ImageNet --data_dir [ImageNet data folder] --model_type ResNet50 --train_type nat --eval --defense_type SafeSpotL2 --delta 3.0 --num_iters 100 --lr 0.01 --attack_type PGDAttackL2 --epsilon 3.0 --num_steps 20 --step_size 0.75 --random_starts 5 --attack_type_test PGDAttackL2 --epsilon_test 3.0 --num_steps_test 20 --step_size_test 0.75 --batch_size 25 --num_images 1000
```

## Reproducing the results of anomaly detection

To reproduce the fine-tuned S-PGD + ADV model, run:
```bash
python src/fine_tune.py
```
After training, place the checkpoint to ```src/checkpoints/cifar10/wideresnet/s_pgd_adv_l2_tune```.

To reproduce the detection result on OOD samples (e.g. LSUN), run:
```bash
python src/detect.py --ood LSUN
```

