package com.example.expandedconv;

import androidx.appcompat.app.AppCompatActivity;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import com.example.expandedconv.databinding.ActivityMainBinding;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MainActivity extends AppCompatActivity {

    // Used to load the 'native-lib' library on application startup.
    static {
//        System.loadLibrary("cnpy");
        System.loadLibrary("native-lib");
    }

    private static final String VERSION = "C8L8";

    private static final String TAG = "Print";
    static final String fileName[] = {"test_img1", "test_img2", "test_img3", "test_img4", "test_img5"};

    static byte[] first_lut, mid_luts, last_lut;
    static final int UPSCALE = 4;

    // UI
    TextView[] textViews = new TextView[3];

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        textViews[0] = findViewById(R.id.textView1);
        textViews[1] = findViewById(R.id.textView2);
        textViews[2] = findViewById(R.id.textView3);

        process();

//        long t = interpolation();
    }

    private void process() {
        // load look-up-table
        AssetManager assetManager = getAssets();
        first_lut = loadLUT(assetManager, String.format("%s/lut_%s_12bit_firstlayer.npy", VERSION, VERSION));
        mid_luts = loadLUT(assetManager, String.format("%s/lut_%s_12bit_midlayers.npy", VERSION, VERSION));
        last_lut = loadLUT(assetManager, String.format("%s/lut_%s_12bit_lastlayer.npy", VERSION, VERSION));

        // load images
        Bitmap[] inputBitmaps = new Bitmap[fileName.length];
        try {
            for (int i = 0; i < fileName.length; i++) {
                inputBitmaps[i] = BitmapFactory.decodeStream(getAssets().open("Image/" + fileName[i] + ".png"));
                Log.d(TAG, "Bitmap config: " + inputBitmaps[i].getConfig());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getExternalFilesDir(null).getAbsolutePath());
        stringBuilder.append("/SR-LUT");
        File dir = new File(stringBuilder.toString());
        if (!dir.exists()) {
            dir.mkdir();
        }

        long t = 0;
        for (int i = 0; i < fileName.length; i++) {
            String outName = fileName[i] + "_output_x4.png";
            File file = new File(stringBuilder.toString(), outName);
            if (file.exists()) {
                file.delete();
            }
            int outWidth = inputBitmaps[i].getWidth() * UPSCALE;
            int outHeight = inputBitmaps[i].getHeight() * UPSCALE;

            try {
                Bitmap out = Bitmap.createBitmap(outWidth, outHeight, Bitmap.Config.ARGB_8888);

                // benchmark
                t += doSRLUT(inputBitmaps[i], out, first_lut, mid_luts, last_lut);
                // textViews[i].setText(fileName[i] + ".png processing time: " + t + " ms");

                FileOutputStream foStream = new FileOutputStream(file);
                out.compress(Bitmap.CompressFormat.PNG, 100, foStream);
                foStream.flush();
                foStream.close();
                Log.d(TAG, "save finished");
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        textViews[0].setText("avg processing time: " + t / fileName.length + " ms");

    }

    /**
     * A native method that is implemented by the 'native-lib' native library,
     * which is packaged with this application.
     */
    public native long doSRLUT(Bitmap lr, Bitmap sr, byte[] first_lut, byte[] mid_luts, byte[] last_lut);

    public native byte[] loadLUT(AssetManager assetManager, String name);

}