# we need to register the following API keys to use the models
# PPLX_API_KEY for PPLX models
# OPENAI_API_KEY for GPT models
# ANTHROPIC_API_KEY for ANTHROPIC models
# DEEPSEEK_API_KEY for DEEPSEEK models
# QWEN_API_KEY for QWEN models

PPLX_AVAILABLE_MODELS = [
    "mixtral-8x7b-instruct",
    "llama-3.1-sonar-large-128k-chat",
    "llama-3.1-sonar-huge-128k-online",
    "llama-3.1-70b-instruct",
]

GPT_AVAILABLE_MODELS = [
    "gpt-3.5-turbo",
    "gpt-4-turbo",
    "gpt-4o",
    "gpt-4o-mini",
]

ANTHROPIC_AVAILABLE_MODELS = [
    "claude-3-5-sonnet-20240620",
    "claude-3-opus-20240229",
    "claude-3-sonnet-20240229",
    "claude-3-haiku-20240307",
]

DEEPSEEK_AVAILABLE_MODELS = [
    "deepseek-coder",
]

QWEN_AVAILABLE_MODELS = [
    "qwen-max-0919",
    "qwen-max",
    "qwen-coder-turbo-latest",
    "qwen-long",
]

OLLAMA_AVAILABLE_MODELS = [
    # general models
    "llama3.1",
    # code models
    "codegeex4",
    "codegeex4-9b-all-fp16",
    "codestral",
    "codestral:22b-v0.1-f16",
    "deepseek-coder-v2",
    "deepseek-coder-v2:16b-lite-instruct-fp16",
    "codegemma",
    "codeqwen",
]
