from src.maxcut import split_polynomial as func
from src.utils import generate_hypergraph

if __name__ == "__main__":
    edges = [[1, 2], [1, 2, 3], [1, 2, 3, 4]]
    poly = func(edges)
    target_poly: dict[tuple, int] = {
        (1,): 3,
        (2,): 3,
        (3,): 2,
        (4,): 1,
        (1, 2): -4,
        (2, 3): -2,
        (1, 3): -2,
        (1, 4): -1,
        (2, 4): -1,
        (3, 4): -1,
        (1, 2, 3): 1,
        (1, 2, 4): 1,
        (1, 3, 4): 1,
        (2, 3, 4): 1,
        (1, 2, 3, 4): -2,
    }
    print(poly)
    assert poly == target_poly

    print(r"#####👇Use hypergraph to test it👇#####")
    hg = generate_hypergraph(9, 100, 200)
    poly = func(hg.e[0])
    # print(poly)
