from src.maxcut.utils import build_hypergraph_maxcut

if __name__ == "__main__":
    edges = [[1, 2], [1, 2, 3], [1, 2, 3, 4]]
    dst_hg = build_hypergraph_maxcut(edges, True, 1)
    target: dict[tuple, int] = {
        (1,): 3,
        (2,): 3,
        (3,): 2,
        (4,): 1,
        (1, 2): -4,
        (2, 3): -2,
        (1, 3): -2,
        (1, 4): -1,
        (2, 4): -1,
        (3, 4): -1,
        (1, 2, 3): 1,
        (1, 2, 4): 1,
        (1, 3, 4): 1,
        (2, 3, 4): 1,
        (1, 2, 3, 4): -2,
    }
    for e, w in zip(*dst_hg.e):
        assert target[e] == -1 * w
    print("✅")

    edges = [[1, 2], [1, 2, 3], [1, 2, 3, 4], [4, 6]]
    dst_hg = build_hypergraph_maxcut(edges, True, 1)
    for e, w in zip(*dst_hg.e):
        print(e, w)
