from dhg import Hypergraph
from src.utils import compact_vertex_indices as func

if __name__ == "__main__":
    edge_list: list[tuple] = [[1, 3, 7], [2, 11], [3, 666, 987]]  # The nodes are not indexed continuously
    hg = Hypergraph(7, edge_list)

    try:
        hg.H
    except:
        print("In the current DHG release, a non-contiguous node index can cause problems")

    comoacted_ineices = func(edge_list, strat=0)
    hg = Hypergraph(7, comoacted_ineices)
    # assert [(1, 2, 3), (4, 5), (2, 6, 7)] == comoacted_ineices
    assert [(0, 1, 2), (3, 4), (1, 5, 6)] == comoacted_ineices
    print(hg.H)