from src.utils import generate_C, generate_hypergraph_Gnm, solve_pubo_with_scip, get_H, generate_hypergraph

if __name__ == "__main__":
    
    k = 5
    num_nodes = 1000
    num_hyperedges = 1200
    hg = generate_hypergraph(k, num_nodes, num_hyperedges)
    
    for v in hg.v:
        hg.add_hyperedges([v])
        
    H = get_H(hg)
    C = generate_C(hg.num_e)
    time_limit = 1000

    solution, loss = solve_pubo_with_scip(num_nodes, hg.num_e, H.cpu(), C.cpu(),
                                        time_limit)
    print("Optimal solution:", solution)
    print("Loss:", loss)
