import torch

from src.loss import loss_pubo
from src.utils import generate_C, generate_hypergraph, solve_pubo_with_tabu, get_H

if __name__ == "__main__":
    k = 4
    num_nodes = 1000
    num_hyperedges = 2000
    hg = generate_hypergraph(k, num_nodes, num_hyperedges)
    H = get_H(hg)
    C = generate_C(hg.num_e)

    solution, loss = solve_pubo_with_tabu(num_nodes, hg.num_e, H.cpu(), C.cpu())
    print("Optimal solution:", solution)
    print("Loss:", loss)
