using SparseArrays

include("SPF.jl")
include("mtx2ar.jl")
include("Clique_sm.jl")
include("mx_func.jl")

function run_and_compare(iterations::Int)
    ar = mtx2ar("fe_4elt2.mtx")
    A = Clique_sm(ar)
    L = 4
    ICr = 0.11
    
    prev_AS = SPF(A, L, ICr)
    
    for i in 2:iterations
        AS = SPF(A, L, ICr)
        
        if AS != prev_AS
            println("Output AS is not the same at iteration ", i)
            return false
        end
        
        prev_AS = AS
    end
    
    println("All output AS are the same for ", iterations, " iterations.")
    return true
end

run_and_compare(10)  # Call the function with the desired number of iterations
