# The Complexity of Finding Local Optima in Contrastive Learning

## Installation

```
pip install -r requirements.txt
```
We recommend using a virtual environment to avoid potential conflicts.

## Run the code

- Max-Cut local search: `python maxcut.py`
- LocalBetweenness-Euclidean reduction: `python betweenness.py`
- LocalContrastive-Euclidean reduction: `python contrastive.py`
- LocalContrastive-Tree reduction: `python contrastive_tree.py`

## Visualize trees (optional)

- Use `visualize_tree.py` to visualize rooted binary trees.
- `visualize_tree(tree, root)` function takes a tree (`nx.DiGraph`) and a root node (`str`) as input.

## Reference

- Monien, Burkhard, and Tobias Tscheuschner. "On the power of nodes of degree four in the local max-cut problem." _Algorithms and Complexity: 7th International Conference, CIAC 2010, Rome, Italy, May 26-28, 2010. Proceedings 7_. Springer Berlin Heidelberg, 2010.
