import random


def H_graph(n):
    edges = []
    f = 0
    edges.append((f"v_{n}_1", f"v_{n}_2", 5))
    for i in range(n, 0, -1):
        # connectors
        edges.append((f"v_{i - 1}_1", f"h_{i}_1", 2 * f + 40))
        edges.append((f"v_{i - 1}_2", f"u_{i}_1", 5))

        # path h_i_1 ... v_i_1
        edges.append((f"h_{i}_1", f"h_{i}_2", 2 * f + 39))
        edges.append((f"h_{i}_2", f"h_{i}_3", 2 * f + 38))
        edges.append((f"h_{i}_3", f"h_{i}_4", 2 * f + 38))
        edges.append((f"h_{i}_4", f"h_{i}_5", 2 * f + 37))
        edges.append((f"h_{i}_5", f"h_{i}_6", 2 * f + 36))
        edges.append((f"h_{i}_6", f"h_{i}_7", 2 * f + 34))
        edges.append((f"h_{i}_7", f"h_{i}_8", 2 * f + 33))
        edges.append((f"h_{i}_8", f"h_{i}_9", 2 * f + 33))
        edges.append((f"h_{i}_9", f"u_{i}_1", 2 * f + 32))
        edges.append((f"u_{i}_1", f"v_{i}", f + 7))
        edges.append((f"v_{i}", f"v_{i}_1", f + 6))

        # cycle u_i_1 ... v_i
        edges.append((f"u_{i}_1", f"h_{i}_11", f + 19))
        edges.append((f"h_{i}_11", f"h_{i}_12", f + 19))
        edges.append((f"h_{i}_12", f"u_{i}_2", f + 19))
        edges.append((f"u_{i}_2", f"h_{i}_13", f + 16))
        edges.append((f"h_{i}_13", f"h_{i}_14", f + 16))
        edges.append((f"h_{i}_14", f"u_{i}_3", f + 14))
        edges.append((f"u_{i}_3", f"h_{i}_15", f + 11))
        edges.append((f"h_{i}_15", f"h_{i}_16", f + 9))
        edges.append((f"h_{i}_16", f"v_{i}", f + 7))

        # bridges from left to right
        edges.append((f"h_{i}_3", f"u_{i}_2", 1))
        edges.append((f"h_{i}_17", f"h_{i}_18", 3))
        edges.append((f"h_{i}_18", f"h_{i}_6", 2))
        edges.append((f"h_{i}_6", f"u_{i}_3", 1))
        edges.append((f"h_{i}_8", f"h_{i}_10", 1))
        edges.append((f"h_{i}_11", f"h_{i}_10", 1))
        edges.append((f"h_{i}_12", f"u_{i}_3", 1))
        edges.append((f"u_{i}_2", f"h_{i}_15", 1))
        edges.append((f"q_{i}_1", f"q_{i}_2", f + 8))
        edges.append((f"q_{i}_2", f"v_{i}", f + 7))
        edges.append((f"h_{i}_15", f"q_{i}_3", 2))
        edges.append((f"q_{i}_3", f"q_{i}_4", 3))
        edges.append((f"h_{i}_13", f"h_{i}_10", 1))
        edges.append((f"h_{i}_10", f"v_{i}_2", 4))
        f = 2 * f + 35

    edges.append(("u_0", "u_1", f + 10))
    edges.append(("u_1", "u_2", f + 9))
    edges.append(("u_2", "h_0_1", f + 9))
    edges.append(("h_0_1", "h_0_2", f + 8))
    edges.append(("h_0_2", "v_0", f + 7))
    edges.append(("v_0", "v_0_1", f + 6))
    edges.append(("u_2", "h_0_3", 1))
    edges.append(("h_0_3", "v_0_2", 4))

    return edges


# 0 for Black, 1 for White
def P_coloring(vertex):
    args = vertex.split("_")
    if len(args) == 2:
        if args[0] == "u":
            return 1 if vertex == "u_0" else 0
        elif args[0] == "v":
            return 0
        else:
            raise ValueError(f"Invalid vertex: {vertex}")
    else:
        i = int(args[1])
        j = int(args[2])

        if args[0] == "h":
            if i == 0:
                return 1 if j in [1, 3] else 0
            else:
                return 1 if j in [2, 4, 6, 8, 10, 12, 13, 16, 17] else 0
        elif args[0] == "u":
            return 1 if j in [1, 3] else 0
        elif args[0] == "v":
            return 1 if j == 1 else 0
        elif args[0] == "q":
            return 1 if j in [1, 3] else 0
        else:
            raise ValueError(f"Invalid vertex: {vertex}")


def max_cut_local_search(edges):
    vertices = set()
    for u, v, _ in edges:
        vertices.add(u)
        vertices.add(v)

    adj = {v: [] for v in vertices}
    for u, v, weight in edges:
        adj[u].append((v, weight))
        adj[v].append((u, weight))

    color = {v: P_coloring(v) for v in vertices}

    def is_happy(u):
        happiness = 0
        for v, weight in adj[u]:
            if color[u] != color[v]:
                happiness += weight
            else:
                happiness -= weight
        return happiness >= 0

    unhappy_vertices = {v for v in vertices if not is_happy(v)}
    flip_count = 0

    while unhappy_vertices:
        u = random.choice(list(unhappy_vertices))
        unhappy_vertices.discard(u)
        color[u] = 1 - color[u]
        for v, _ in adj[u]:
            if is_happy(v):
                unhappy_vertices.discard(v)
            else:
                unhappy_vertices.add(v)
        flip_count += 1

    return len(vertices), len(edges), flip_count


def main():
    for i in range(1, 16):
        edges = H_graph(i)
        num_vertices, num_edges, flip_count = max_cut_local_search(edges)
        print(f"n={i}: {num_vertices} vertices, {num_edges} edges, {flip_count} flips")


if __name__ == "__main__":
    main()
