# Training Diffusion Classifiers with Denoising-Assistance: DDPMs

This repository heavily builds upon [Guided Diffusion](https://github.com/openai/guided-diffusion/). 

Download the pretrained 256x256 imagenet classifier and 256x256 unconditional diffusion model inside a directory called ```workdirs```. In order to finetune the pretrained imagenet diffusion classifier with denoising assistance, you can use:
>MODEL_FLAGS="--attention_resolutions 32,16,8 --class_cond False --diffusion_steps 1000 --image_size 256 --learn_sigma True --noise_schedule linear --num_channels 256 --num_head_channels 64 --num_res_blocks 2 --resblock_updown True --use_fp16 True --use_scale_shift_norm True"

>TRAIN_FLAGS="--lr 1e-5 --weight_decay 0 --anneal_lr False"

>mpiexec -n 1 python da_classifier_train.py $MODEL_FLAGS $TRAIN_FLAGS --denoise_augment True --log_dir workdirs/im_clf_DA --batch_size 128 --microbatch 32 --classifier_use_fp16 True

In order to generate examples with DDIM-25, you can use:
>MODEL_FLAGS="--attention_resolutions 32,16,8 --class_cond False --diffusion_steps 1000 --image_size 256 --learn_sigma True --noise_schedule linear --num_channels 256 --num_head_channels 64 --num_res_blocks 2 --resblock_updown True --use_fp16 True --use_scale_shift_norm True"

>mpiexec -n 1 python da_classifier_sample.py $MODEL_FLAGS --num_samples 4120 --batch_size 8  --timestep_respacing ddim25 --use_ddim True --denoise_augment True --ID 0 --classifier_scale 2.5

The sampling code uses class-conditional diffusion and you can download the 256x256 conditional diffusion model into the workdirs. You can use ```ID``` to run the sampling in parallel such that the npz files aren't overwritten. Finally, all the npz files can be aggregated by a simple script (not included) and used for evaluation following https://github.com/openai/guided-diffusion/tree/main/evaluations. 