import os

def check_file_exists(path):
    """Check if a file exists at the given path"""
    return os.path.isfile(path)

def check_dir_exists(path):
    """Check if a directory exists at the given path"""
    return os.path.isdir(path)

def files_and_directories(path):
    """Check if required files and directories exist and return a report"""
    files = [
        "metric.py",
        "prepare.py", 
        "test.py",
        "description.txt",
        "public/train.csv",
        "public/test.csv",
        "public/sample_submission.csv",
        "private/test_answer.csv"
    ]

    dirs = [
        "samples/",
        "raw/",
        "public/",
        "private/",
    ]

    report = {
        "existing_files": [],
        "missing_files": [],
        "existing_dirs": [],
        "missing_dirs": []
    }

    # Check directories
    for dir in dirs:
        full_path = os.path.join(path, dir)
        if check_dir_exists(full_path):
            report["existing_dirs"].append(dir)
        else:
            report["missing_dirs"].append(dir)

    # Check files
    for file in files:
        full_path = os.path.join(path, file)
        if check_file_exists(full_path):
            report["existing_files"].append(file)
        else:
            report["missing_files"].append(file)

    # Determine if all required files and directories exist
    all_exist = len(report["missing_files"]) == 0 and len(report["missing_dirs"]) == 0

    return all_exist, report




