# name: run_python
# docstring: Run a Python script
# arguments:
#   script:
#     type: string
#     description: Path to the Python script to run
#     required: true
run_python() {
    if [ -z "$1" ]; then
        echo "Error: No script provided"
        return 1
    fi
    if [ ! -f "$1" ]; then
        echo "Error: Script not found"
        return 1
    fi
    python "$1"
}

# name: run_bash
# docstring: Run a bash command or script
# arguments:
#   command:
#     type: string
#     description: Command or script to run
#     required: true
run_bash() {
    if [ -z "$1" ]; then
        echo "Error: No command or script provided"
        return 1
    fi
    # if the provided argument is a file, run it
    if [ -f "$1" ]; then
        bash "$1"
    else
        # if the provided argument is a command, run it
        bash -c "$1"
    fi
}

# name: list_dir
# docstring: List files and directories in the current directory or in the specified directory
# arguments:
#   dir:
#     type: string
#     description: Directory to list
#     required: false
list_dir() {
    # if dir is not provided, list the current directory
    if [ -z "$1" ]; then
        ls -lF ./
        return
    fi
    ls -lF "$1"
}

# name: change_dir
# docstring: Change the current directory
# arguments:
#   dir:
#     type: string
#     description: Directory to change to
#     required: true
change_dir() {
    if cd "$1"; then
        return 0
    else
        echo "Error: Failed to change directory to $1"
        return 1
    fi
}

# name: make_dir
# docstring: Create a new directory
# arguments:
#   dir:
#     type: string
#     description: Name of directory to create
#     required: true
make_dir() {
    mkdir -p "$1"
}

# name: remove_file
# docstring: Remove a file
# arguments:
#   file:
#     type: string
#     description: Name of file to remove
#     required: true
remove_file() {
    rm -f "$1"
}

# name: remove_dir
# docstring: Remove a directory
# arguments:
#   dir:
#     type: string
#     description: Name of directory to remove
#     required: true
remove_dir() {
    rm -rf "$1"
}

# name: copy_file
# docstring: Copy a file
# arguments:
#   source:
#     type: string
#     description: Path to the file to copy
#     required: true
#   destination:
#     type: string
#     description: Path to the destination of the copied file
#     required: true
copy_file() {
    cp "$1" "$2"
}

# name: move_file
# docstring: Move a file
# arguments:
#   source:
#     type: string
#     description: Path to the file to move
#     required: true
#   destination:
#     type: string
#     description: Path to the destination of the moved file
#     required: true
move_file() {
    mv "$1" "$2"
}