# name: submit
# docstring: Submits the current file for grading
submit() {
    cd $ROOT

    # Check if the patch file exists and is non-empty
    if [ -s "/root/test.patch" ]; then
        # Apply the patch in reverse
        git apply -R < "/root/test.patch"
    fi

    # Only create diff cached for non test related files
    git add -A
    git diff --cached \
        -- $(git diff --cached --name-only | grep -E '\.py$|\.c$|\.cpp$|\.java$|\.scala$|\.rs$|\.go$|\.js$' \
        | grep -Ev '\/test\/|\/tests\/|\/testing\/|test\.|\.test|test\/|test\.' ) \
        > model.patch

    echo "<<SUBMISSION||"
    cat model.patch
    echo "||SUBMISSION>>"
}