#PACKAGES -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

using Optim, Plots, DelimitedFiles, LinearAlgebra, Random, StatsBase, FiniteDifferences, LaTeXStrings , EasyFit, Printf, FFTW, Pkg, Noise, Clustering, Dierckx, BSplineKit, MultivariateStats, Flux, Combinatorics, Bigsimr, DataFrames, JLD, Distributions, FFTW, Statistics

#FUNCTIONS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Functions for Todorov's and Numerical GD algorithms (1D)
cd(@__DIR__)#to go back to the directory of the script
include("../MyFunctions/functions_TOD_and_GD_1D.jl")

#Functions for full GD algorithms (1D and multiple dimensions)
cd(@__DIR__)#to go back to the directory of the script
include("../MyFunctions/functions_full_GD_algorithms.jl")

#TASK PARAMETERS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Σ_x_0 = 0.0  # one of these two variances (note that they're variances) must be set at zero [probably we should always have Σ_z_0 = 0 to be consisten with (Todorov, 2005)--> see point (A) in "TO BE EXPLORED" session in the file "functions_full_GD_algorithms.jl"]
Σ_z_0 = 0.0
μ_x_0 = 1.0  # these two variables, the initial means of the state and state estimate, should be the same
μ_z_0 = μ_x_0
x_z_0_mean = μ_x_0
T =  100 #Note that T must be T>2 to have a non-trivial problem and to make the scripts run (with T=2 there is no estimation problem to solve)
q = 1
q_T = 20 #q_T is the weight of the terminal state in the cost function, higher than q to make the terminal state more important (being the task relevant cost in most of the cases)
r = 1
a = 1.0
b = 1.0
m = a
n = b
H = 1
σ_ξ = 0.5
σ_ϵ_control_dep_noise = 0.5
σ_ω_add_sensory_noise = 0.5
σ_ρ_mult_sensory_noise = 0.5 
σ_η_internal_noise = 0.0

#OPTIMIZATION PARAMETERS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Define the initial guess for the parameter vector to be optimized
k_0 = a                           
l_0 = -0.6  #l has opposite sign wrt Todorov paper, be careful {usually, the control is negative}

#Numerical GD 
algorithm_GD = GradientDescent()
iterations_GD = 5000
# Specify options for the optimization algorithm
options_GD = Optim.Options(
    # Step size for gradient descent
    iterations = iterations_GD,  # Number of iterations
    store_trace = false   # Show optimization trace
)

#x_0 is the initial condition for the vector optmised in the classic GD optimisation. Below we set the initial condition as Todorov's solutions for k_t and l_t.
x_0 = k_0 .* ones(2*(T-1))        #we assume uniform values for k_0 and l_0 as initial conditions before the optimization
x_0[T:2*(T-1)] = l_0 .* ones(T-1)

x_0_l = l_0 .* ones(T-1)
x_0_k = k_0 .* ones(T-1)

#MC simulations
realizations_for_averaged_cost = 10000 #it depends on the noise level, but to get accurate estimates through the MC method, it seems we should use realizations ≈ 10^4 at least (as soon 
seed_MC = 6789

### ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Test about optimality of control gains: we fix k and optimise l with GD and TOD and check whether Todorov's algorithm acutally finds the optimal controller for each estimator 
#(regardless of the optimality of the filters), in the absence of internal noise.

σ_ξ_values = [0.5]
σ_ϵ_control_dep_noise_values = [0.5]
σ_ω_add_sensory_noise_values = [0.5]
σ_ρ_mult_sensory_noise_values = [0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0]
σ_η_internal_noise_values = [0.0] 

k_fixed = k_0 .* ones(T-1)
l_opt_TOD = zeros(length(σ_ξ_values),length(σ_ϵ_control_dep_noise_values),length(σ_ω_add_sensory_noise_values), length(σ_ρ_mult_sensory_noise_values), length(σ_η_internal_noise_values), T-1)
l_opt_GD = zeros(length(σ_ξ_values),length(σ_ϵ_control_dep_noise_values),length(σ_ω_add_sensory_noise_values), length(σ_ρ_mult_sensory_noise_values), length(σ_η_internal_noise_values), T-1)

MC_cost_TOD = zeros(length(σ_ξ_values),length(σ_ϵ_control_dep_noise_values),length(σ_ω_add_sensory_noise_values), length(σ_ρ_mult_sensory_noise_values), length(σ_η_internal_noise_values))
MC_error_cost_TOD = zeros(length(σ_ξ_values),length(σ_ϵ_control_dep_noise_values),length(σ_ω_add_sensory_noise_values), length(σ_ρ_mult_sensory_noise_values), length(σ_η_internal_noise_values))

MC_cost_GD = zeros(length(σ_ξ_values),length(σ_ϵ_control_dep_noise_values),length(σ_ω_add_sensory_noise_values), length(σ_ρ_mult_sensory_noise_values), length(σ_η_internal_noise_values))
MC_error_cost_GD = zeros(length(σ_ξ_values),length(σ_ϵ_control_dep_noise_values),length(σ_ω_add_sensory_noise_values), length(σ_ρ_mult_sensory_noise_values), length(σ_η_internal_noise_values))

#Threads.@threads to compute all expcted costs and optimal strategies per each noise configuration
Threads.@threads for i_idx in 1:length(σ_ξ_values)
    σ_ξ = σ_ξ_values[i_idx]
    for j_idx in 1:length(σ_ϵ_control_dep_noise_values)
        σ_ϵ_control_dep_noise = σ_ϵ_control_dep_noise_values[j_idx]
        for k_idx in 1:length(σ_ω_add_sensory_noise_values)
            σ_ω_add_sensory_noise = σ_ω_add_sensory_noise_values[k_idx]
            for l_idx in 1:length(σ_ρ_mult_sensory_noise_values)
                σ_ρ_mult_sensory_noise = σ_ρ_mult_sensory_noise_values[l_idx]
                for m_idx in 1:length(σ_η_internal_noise_values)
                    σ_η_internal_noise = σ_η_internal_noise_values[m_idx]

                    l_opt_TOD[i_idx,j_idx,k_idx,l_idx,m_idx,:] = L_optimal_Todorov_CONTROL(-l_0, k_fixed, a, b, H, r, q, q_T, σ_ϵ_control_dep_noise, σ_ρ_mult_sensory_noise, T)
                    
                    x_0_l[:] = l_opt_TOD[i_idx,j_idx,k_idx,l_idx,m_idx,:]

                    cost_function_optimization_GD(x) = expected_cost_moments_propagation_k_l_separated(Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, q, q_T, r, a, b, m, n, H, k_fixed, x, σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_internal_noise)
                    result_GD = optimize(cost_function_optimization_GD, x_0_l, algorithm_GD, options_GD)
                    x_opt_GD = result_GD.minimizer

                    l_opt_GD[i_idx,j_idx,k_idx,l_idx,m_idx,:] = x_opt_GD[1:T-1]
                    
                    #MC costs
                    MC_cost_TOD[i_idx,j_idx,k_idx,l_idx,m_idx], MC_error_cost_TOD[i_idx,j_idx,k_idx,l_idx,m_idx], _ = cost_MC_sampling(realizations_for_averaged_cost, seed_MC, Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, q, q_T, r, a, b, m, n, H, l_opt_TOD[i_idx,j_idx,k_idx,l_idx,m_idx,:], k_fixed, σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_internal_noise)
                    MC_cost_GD[i_idx,j_idx,k_idx,l_idx,m_idx], MC_error_cost_GD[i_idx,j_idx,k_idx,l_idx,m_idx], _ = cost_MC_sampling(realizations_for_averaged_cost, seed_MC, Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, q, q_T, r, a, b, m, n, H, l_opt_GD[i_idx,j_idx,k_idx,l_idx,m_idx,:], k_fixed, σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_internal_noise)

                end
            end
        end
    end
end

###SAVE THE DATA ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

cd(@__DIR__)#to go back to the directory of the script
folder_location = "../Data/1D_problem_fixing_L_and_K/New_Data"

#Todorov
file_name_save = "1D_problem_l_opt_TOD_fixing_K.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "l_opt_TOD", l_opt_TOD)

file_name_save = "1D_problem_MC_cost_TOD_fixing_K.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "MC_cost_TOD", MC_cost_TOD)

file_name_save = "1D_problem_MC_error_cost_TOD_fixing_K.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "MC_error_cost_TOD", MC_error_cost_TOD)

#GD
file_name_save = "1D_problem_l_opt_GD_fixing_K.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "l_opt_GD", l_opt_GD)

file_name_save = "1D_problem_MC_cost_GD_fixing_K.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "MC_cost_GD", MC_cost_GD)

file_name_save = "1D_problem_MC_error_cost_GD_fixing_K.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "MC_error_cost_GD", MC_error_cost_GD)

##### SAME, but fixing L instead of K (and optimizing for K) ##### ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

σ_ξ_values_L_fixed = [0.5]
σ_ϵ_control_dep_noise_values_L_fixed = [0.5]
σ_ω_add_sensory_noise_values_L_fixed = [0.5]
σ_ρ_mult_sensory_noise_values_L_fixed = [0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0]
σ_η_internal_noise_values_L_fixed = [0.0] 

l_fixed = l_0 .* ones(T-1)
k_opt_TOD_L_fixed = zeros(length(σ_ξ_values_L_fixed),length(σ_ϵ_control_dep_noise_values_L_fixed),length(σ_ω_add_sensory_noise_values_L_fixed), length(σ_ρ_mult_sensory_noise_values_L_fixed), length(σ_η_internal_noise_values_L_fixed), T-1)
k_opt_GD_L_fixed = zeros(length(σ_ξ_values_L_fixed),length(σ_ϵ_control_dep_noise_values_L_fixed),length(σ_ω_add_sensory_noise_values_L_fixed), length(σ_ρ_mult_sensory_noise_values_L_fixed), length(σ_η_internal_noise_values_L_fixed), T-1)

MC_cost_TOD_L_fixed = zeros(length(σ_ξ_values_L_fixed),length(σ_ϵ_control_dep_noise_values_L_fixed),length(σ_ω_add_sensory_noise_values_L_fixed), length(σ_ρ_mult_sensory_noise_values_L_fixed), length(σ_η_internal_noise_values_L_fixed))
MC_error_cost_TOD_L_fixed = zeros(length(σ_ξ_values_L_fixed),length(σ_ϵ_control_dep_noise_values_L_fixed),length(σ_ω_add_sensory_noise_values_L_fixed), length(σ_ρ_mult_sensory_noise_values_L_fixed), length(σ_η_internal_noise_values_L_fixed))

MC_cost_GD_L_fixed = zeros(length(σ_ξ_values_L_fixed),length(σ_ϵ_control_dep_noise_values_L_fixed),length(σ_ω_add_sensory_noise_values_L_fixed), length(σ_ρ_mult_sensory_noise_values_L_fixed), length(σ_η_internal_noise_values_L_fixed))
MC_error_cost_GD_L_fixed = zeros(length(σ_ξ_values_L_fixed),length(σ_ϵ_control_dep_noise_values_L_fixed),length(σ_ω_add_sensory_noise_values_L_fixed), length(σ_ρ_mult_sensory_noise_values_L_fixed), length(σ_η_internal_noise_values_L_fixed))

#Threads.@threads
Threads.@threads for i_idx in 1:length(σ_ξ_values_L_fixed)
    σ_ξ = σ_ξ_values_L_fixed[i_idx]
    for (j_idx,σ_ϵ_control_dep_nosie) in enumerate(σ_ϵ_control_dep_noise_values_L_fixed)
        for (k_idx,σ_ω_add_sensory_noise) in enumerate(σ_ω_add_sensory_noise_values_L_fixed)
            for (l_idx,σ_ρ_mult_sensory_noise) in enumerate(σ_ρ_mult_sensory_noise_values_L_fixed)
                for (m_idx,σ_η_internal_noise) in enumerate(σ_η_internal_noise_values_L_fixed)
                    
                    k_opt_TOD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx,:] = K_optimal_Todorov_ESTIMATOR(x_z_0_mean, Σ_x_0, Σ_z_0, -l_fixed, a, b, H, σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_internal_noise,T)
    
                    x_0_k[:] = k_opt_TOD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx,:]

                    cost_function_optimization_GD(x) = expected_cost_moments_propagation_k_l_separated(Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, q, q_T, r, a, b, m, n, H, x, l_fixed, σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_internal_noise)
                    result_GD = optimize(cost_function_optimization_GD, x_0_k, algorithm_GD, options_GD)
                    x_opt_GD = result_GD.minimizer

                    k_opt_GD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx,:] = x_opt_GD[1:T-1]
                    
                    #MC costs
                    MC_cost_TOD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx], MC_error_cost_TOD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx], _ = cost_MC_sampling(realizations_for_averaged_cost, seed_MC, Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, q, q_T, r, a, b, m, n, H, l_fixed, k_opt_TOD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx,:], σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_internal_noise)
                    MC_cost_GD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx], MC_error_cost_GD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx], _ = cost_MC_sampling(realizations_for_averaged_cost, seed_MC, Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, q, q_T, r, a, b, m, n, H, l_fixed, k_opt_GD_L_fixed[i_idx,j_idx,k_idx,l_idx,m_idx,:], σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_internal_noise)

                end
            end
        end
    end
end

###SAVE THE DATA ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

cd(@__DIR__)#to go back to the directory of the script
folder_location = "../Data/1D_problem_fixing_L_and_K/New_Data"

#Todorov
file_name_save = "1D_problem_k_opt_TOD_fixing_L.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "k_opt_TOD", k_opt_TOD_L_fixed)

file_name_save = "1D_problem_MC_cost_TOD_fixing_L.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "MC_cost_TOD", MC_cost_TOD_L_fixed)

file_name_save = "1D_problem_MC_error_cost_TOD_fixing_L.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "MC_error_cost_TOD", MC_error_cost_TOD_L_fixed)

#GD
file_name_save = "1D_problem_k_opt_GD_fixing_L.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "k_opt_GD", k_opt_GD_L_fixed)

file_name_save = "1D_problem_MC_cost_GD_fixing_L.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "MC_cost_GD", MC_cost_GD_L_fixed)

file_name_save = "1D_problem_MC_error_cost_GD_fixing_L.jld"
file_path_save = folder_location * "/" *file_name_save
save(file_path_save, "MC_error_cost_GD", MC_error_cost_GD_L_fixed)