import argparse

"""
Here are the param for the training
#Configurations

# 4 * 4 maze
#from Maze_denseR import Maze

# 8 * 8 maze
from Maze_large1 import Maze


episode_total_reward = []
Total_Rewards = 0

mean_episode_reward_list = []
task_completed_step = []

total_episode = 10000
total_step = 10

"""


def get_args():
    parser = argparse.ArgumentParser("Reinforcement Learning experiments for multiagent environments")
    # Environment
    parser.add_argument("--maze-name", type=str, default="./Maze_denseR.py", help="name of the scenario script")

    parser.add_argument("--maze-H", type=int, default=6, help="maze height")
    parser.add_argument("--maze-W", type=int, default=6, help="maze width")

    parser.add_argument("--scenario-name", type=str, default="3_agent_maze_6_6_run1", help="name of the scenario script")
    parser.add_argument("--max-episode-len", type=int, default=6, help="maximum episode length, which is the number of steps per episode")
    parser.add_argument("--num-episodes", type=int, default=10000, help="number of total episodes")


    parser.add_argument("--sampling-method", type=str, default="SamplingActionTrajectoriesFro_100_Episodes", help="name of the sampling method for baselines DT, named by how many episodes sampled")
    parser.add_argument("--max-sampling-episode-len", type=int, default=6, help="maximum episode length, which is the number of steps per episode for sampling action trajectories")
    parser.add_argument("--num-sampling-episodes", type=int, default=10000, help="number of total sampling episodes for sampling action trajectories")

    # Core training parameters
    parser.add_argument("--num-clusters", type=int, default=4, help="number of clustering labels, how many different labels could be chosen from")
    parser.add_argument("--max-leaf-nodes", type=int, default=8, help="leaf nodes constraints in the Decision Tree")
    parser.add_argument("--max-depth", type=int, default=6, help="max depth constraints in the RGMDT and BASELINES Decision Tree,2,4,6")
    parser.add_argument("--max-depth-RGMDT", type=int, default=3, help="max depth constraints in the RGMDT Decision Tree,2,4,6")
    parser.add_argument("--max-depth-baseline", type=int, default=2, help="max depth constraints in the Baseline Decision Tree,2,4,6")


    parser.add_argument("--random-seed", type=int, default=666, help="random seed for different runs,55,222,666")





    # Outputs
    # Models
    parser.add_argument("--save-DTModel-dir", type=str, default="./outputs/model", help="directory in which trained decision tree models should be saved")
    parser.add_argument("--load-DTModel-dir", type=str, default="./outputs/model", help="directory in which trained decision tree models should be loaded")

    # Data
    parser.add_argument("--save-data-dir", type=str, default="./outputs/data", help="directory in which trained data should be saved")
    parser.add_argument("--load-data-dir", type=str, default="./outputs/data", help="directory in which trained data should be loaded")

    # Figs
    parser.add_argument("--save-fig-dir", type=str, default="./outputs/fig", help="directory in which generated fig should be saved")
    parser.add_argument("--load-fig-dir", type=str, default="./outputs/fig", help="directory in which generated fig should be loaded")




    # Evaluate in step 3
    parser.add_argument("--evaluate-episodes", type=int, default=100, help="number of episodes for evaluating")
    parser.add_argument("--evaluate-episode-len", type=int, default=3, help="length of episodes for evaluating")


    args = parser.parse_args()

    return args
