
import pennylane as qml
from pennylane.templates import AmplitudeEmbedding
import numpy as np
import matplotlib.pyplot as plt
import random
import numpy.linalg as la
from pennylane.templates import BasicEntanglerLayers
import math
import random
from math import pi
from pennylane.init import basic_entangler_layers_normal
from pennylane.templates.layers import RandomLayers
from pennylane.ops import CNOT, RX, RY, RZ
from datetime import datetime


def draw(iteration, check_slide):

    figure_iteration_x = range(1,1+iteration, check_slide)
    figure_gradient_x = np.zeros(2*iteration)
    for i in range(2*iteration):
        figure_gradient_x[i] = 0.5 *(1+i)

    tt_train_error = np.load("ttn_train_error_8.npy")
    tt_test_error = np.load("ttn_test_error_8.npy")
    tt_train_loss = np.load("ttn_train_loss_8.npy")
    tt_test_loss = np.load("ttn_test_loss_8.npy")
    tt_gradient_norm = np.load("ttn_gradnorm_8.npy")
    random_train_error = np.load("random_train_error_8.npy")
    random_test_error = np.load("random_test_error_8.npy")
    random_train_loss = np.load("random_train_loss_8.npy")
    random_test_loss = np.load("random_test_loss_8.npy")
    random_gradient_norm = np.load("random_gradnorm_8.npy")
    # figure of the error
    plt.plot(figure_iteration_x, tt_train_error, '--', label = "TT QNN train", color = 'red', lw = 2)
    plt.plot(figure_iteration_x, tt_test_error,  label = "TT QNN test", color = 'red', lw = 2)
    plt.plot(figure_iteration_x, random_train_error, '--', label = "Random QNN train", color = 'blue', lw = 2)
    plt.plot(figure_iteration_x, random_test_error, label = "Random QNN test", color = 'blue', lw = 2)
    plt.xlabel('training iteration', fontsize = 16)
    plt.ylabel('error', fontsize = 16)
    #    plt.ylim(0, 1)
    # Show the major grid lines with dark grey lines
    plt.grid(b=True, which='major', color='#666666', linestyle='--')
    # Show the minor grid lines with very faint and almost transparent grey lines
    plt.minorticks_on()
    plt.grid(b=True, which='minor', color='#999999', linestyle=':', alpha=0.2)
    plt.legend()
    plt.savefig('all_error_sgd.eps')
    plt.close()
    # figure of the loss
    plt.plot(figure_iteration_x, tt_train_loss, '--', label = "TT QNN train", color = 'red', lw = 2)
    plt.plot(figure_iteration_x, tt_test_loss, label = "TT QNN test", color = 'red', lw = 2)
    plt.plot(figure_iteration_x, random_train_loss, '--', label = "Random QNN train", color = 'blue', lw = 2)
    plt.plot(figure_iteration_x, random_test_loss, label = "Random QNN test", color = 'blue', lw = 2)
    plt.xlabel('training iteration', fontsize = 16)
    plt.ylabel('loss', fontsize = 16)
    #    plt.ylim(0, 1)
    # Show the major grid lines with dark grey lines
    plt.grid(b=True, which='major', color='#666666', linestyle='--')
    # Show the minor grid lines with very faint and almost transparent grey lines
    plt.minorticks_on()
    plt.grid(b=True, which='minor', color='#999999', linestyle=':', alpha=0.2)
    plt.legend()
    plt.savefig('all_loss_sgd.eps')
    plt.close()
    # figure of the gradient norm
    plt.plot(figure_gradient_x, tt_gradient_norm, label = "TT QNN")
    plt.plot(figure_gradient_x, random_gradient_norm, label = "Random QNN")
    plt.xlabel('training iteration', fontsize = 16)
    plt.ylabel('gradient norm', fontsize = 16)
    #    plt.ylim(0, 1)
    # Show the major grid lines with dark grey lines
    plt.grid(b=True, which='major', color='#666666', linestyle='--')
    # Show the minor grid lines with very faint and almost transparent grey lines
    plt.minorticks_on()
    plt.grid(b=True, which='minor', color='#999999', linestyle=':', alpha=0.2)
    plt.legend()
    plt.savefig('all_gradnorm_sgd.eps')
    plt.close()

    tt_train_error = np.load("ttn_train_error_8_sngd.npy")
    tt_test_error = np.load("ttn_test_error_8_sngd.npy")
    tt_train_loss = np.load("ttn_train_loss_8_sngd.npy")
    tt_test_loss = np.load("ttn_test_loss_8_sngd.npy")
    random_train_error = np.load("random_train_error_8_sngd.npy")
    random_test_error = np.load("random_test_error_8_sngd.npy")
    random_train_loss = np.load("random_train_loss_8_sngd.npy")
    random_test_loss = np.load("random_test_loss_8_sngd.npy")

    # figure of the error
    plt.plot(figure_iteration_x, tt_train_error, '--', label = "TT QNN train", color = 'red', lw = 2)
    plt.plot(figure_iteration_x, tt_test_error,  label = "TT QNN test", color = 'red', lw = 2)
    plt.plot(figure_iteration_x, random_train_error, '--', label = "Random QNN train", color = 'blue', lw = 2)
    plt.plot(figure_iteration_x, random_test_error, label = "Random QNN test", color = 'blue', lw = 2)
    plt.xlabel('training iteration', fontsize = 16)
    plt.ylabel('error', fontsize = 16)
    #    plt.ylim(0, 1)
    # Show the major grid lines with dark grey lines
    plt.grid(b=True, which='major', color='#666666', linestyle='--')
    # Show the minor grid lines with very faint and almost transparent grey lines
    plt.minorticks_on()
    plt.grid(b=True, which='minor', color='#999999', linestyle=':', alpha=0.2)
    plt.legend()
    plt.savefig('all_error_sngd.eps')
    plt.close()
    # figure of the loss
    plt.plot(figure_iteration_x, tt_train_loss, '--', label = "TT QNN train", color = 'red', lw = 2)
    plt.plot(figure_iteration_x, tt_test_loss, label = "TT QNN test", color = 'red', lw = 2)
    plt.plot(figure_iteration_x, random_train_loss, '--', label = "Random QNN train", color = 'blue', lw = 2)
    plt.plot(figure_iteration_x, random_test_loss, label = "Random QNN test", color = 'blue', lw = 2)
    plt.xlabel('training iteration', fontsize = 16)
    plt.ylabel('loss', fontsize = 16)
    #    plt.ylim(0, 1)
    # Show the major grid lines with dark grey lines
    plt.grid(b=True, which='major', color='#666666', linestyle='--')
    # Show the minor grid lines with very faint and almost transparent grey lines
    plt.minorticks_on()
    plt.grid(b=True, which='minor', color='#999999', linestyle=':', alpha=0.2)
    plt.legend()
    plt.savefig('all_loss_sngd.eps')
    plt.close()

    return 0
