function dx = dynamics(obj, ~, x, u, d)
% Dynamics of the Dubins Car
%    \dot{x}_1 = v * cos(x_3)
%    \dot{x}_2 = v * sin(x_3)
%    \dot{x}_3 = w
%   Control: u = w;
%
% Mo Chen, 2016-06-08

u = NN_control(x);

if nargin < 5
  d = [0; 0];
end

if iscell(x)
  dx = cell(length(obj.dims), 1);
  
  for i = 1:length(obj.dims)
    dx{i} = dynamics_cell_helper(obj, x, u, d, obj.dims, obj.dims(i));
  end
else
  dx = zeros(obj.nx, 1);
  
  dx(1) = u(2) * cos(u(1)) + d(1);
  dx(2) = u(2) * sin(u(1)) + d(2);
  %dx(3) = u;
end
end

function dx = dynamics_cell_helper(obj, x, u, d, dims, dim)

switch dim
  case 1
    dx = u{2} * cos(u{1}) + d{1};
  case 2
    dx = u{2} * sin(u{1}) + d{2};
  %case 3
  %  dx = u;
  otherwise
    error('Only dimension 1-2 are defined for dynamics of DubinsCar!')
end
end

function out = NN_control(s)
    
     Wc1 =  [0.8313782811164856, 0.15559861063957214, 0.5326681733131409, 0.1849670708179474;
 -0.2256658375263214, -0.22868072986602783, -0.1417354792356491, 0.08852024376392365;
 -0.02881418727338314, -0.2410210371017456, -0.021307608112692833, 0.6292443871498108;
 0.14415863156318665, -0.4134516417980194, -0.3117040693759918, -0.12774120271205902;
0.32753655314445496, 0.13443095982074738, -0.1531790792942047, 0.36564043164253235;
-0.22484062612056732, -0.2724253237247467, -0.47594183683395386, 0.2088063806295395;
-0.4492831528186798, 0.2284267097711563, -0.1621183604001999, -0.3508151173591614;
0.009159226901829243, 0.19016236066818237, -0.524039089679718, 0.07271862030029297;
-0.29428374767303467, -0.12295034527778625, -0.2537156939506531, -0.20492883026599884;
0.554144561290741, -0.4831535518169403, -0.2683440148830414, 0.35990944504737854;
-0.05999881029129028, -0.21791405975818634, 0.07283193618059158, -0.5664944648742676;
0.3686504364013672, -0.3097430467605591, -0.2278723418712616, 0.3104833662509918;
0.19689764082431793, -0.2549634277820587, 0.38598617911338806, -0.02047612890601158;
0.5435080528259277, 0.5527206659317017, -0.04640314355492592, 0.4814913868904114];


    bc1 =  [-0.24754483997821808, 0.15010331571102142, 0.5408475399017334, -0.5377054214477539, 0.40219154953956604, -0.3008671700954437, 0.6345354318618774, 0.546658992767334, -0.22573257982730865, -0.36092615127563477, -0.7137397527694702, -0.44004344940185547, 0.6849840879440308, 0.9629192352294922]';

    Wc2 =  [-0.4736832082271576, 0.4154437482357025, -1.694002389907837, 0.9816133975982666, -0.9021338224411011, 1.9490482807159424, -1.467972755432129, -0.9690372943878174, 0.8637089729309082, 1.157187819480896, 1.218520998954773, 1.2404648065567017, -1.7278051376342773, -1.176113486289978;
 -0.16342787444591522, -0.20145517587661743, 0.06459111720323563, -0.17366595566272736, -0.21908989548683167, -0.15443626046180725, -0.22059474885463715, 0.0121819619089365, 0.13181748986244202, 0.09491481631994247, 0.017735294997692108, 0.13701677322387695, 0.12088605016469955, 0.05204646661877632];
   
bc2 = [-0.779100775718689, 0.18770229816436768]';

    

    for i=1:1
        int1 = vpa(tanh([Wc1, bc1] * [s;1]));
        temp = vpa([Wc2, bc2] * [int1;1]);
        sig = vpa((1./(1 + exp(-temp))));
        tn = vpa(tanh(temp));
        v = vpa(sig(1)*0.1);
        theta = vpa(tn(2)*vpa(pi));
        

    end
     
    out = [theta; v];

end