classdef ToyExample5 < DynSys
  properties
    % Angle bounds
    uRange
    
    %speed % Constant speed
    
    % Disturbance
    dRange
    
    % Dimensions that are active
    dims
  end
  
  methods
    function obj = ToyExample5(x, uRange, dRange, dims)
      % obj = DubinsCar(x, wMax, speed, dMax, dims)
      %     Dubins Car class
      %
      % Dynamics:
      %    \dot{x}_1 = v * cos(x_3) + d1
      %    \dot{x}_2 = v * sin(x_3) + d2
      %    \dot{x}_3 = u
      %         u \in [-wMax, wMax]
      %         d \in [-dMax, dMax]
      %
      % Inputs:
      %   x      - state: [xpos; ypos]
      %   thetaMin   - minimum angle
      %   thetaMax   - maximum angle
      %   v - speed
      %   dMax   - disturbance bounds
      %
      % Output:
      %   obj       - a DubinsCar2D object
      
      if numel(x) ~= obj.nx
        error('Initial state does not have right dimension!');
      end
      
      if ~iscolumn(x)
        x = x';
      end
      
      if nargin < 2
        uRange = {[0; -3.14; -3.14];[5; 3.14; 3.14]};
      end
      
%       if nargin < 3
%         speed = 5;
%       end
      
      if nargin < 3
        dRange = {[0; 0; 0];[ 0; 0; 0]};
      end
      
      if nargin < 4
        dims = 1:3;
      end
      
      if ~iscell(uRange)
          uRange = {-uRange,uRange};
      end
      
      if ~iscell(dRange)
          dRange = {-dRange,dRange};
      end
      
      % Basic vehicle properties
      obj.pdim = [find(dims == 1) find(dims == 2) find(dims == 3)]; % Position dimensions
      %obj.hdim = find(dims == 3);   % Heading dimensions
      obj.nx = length(dims);
      obj.nu = 3;
      obj.nd = 3;
      
      obj.x = x;
      obj.xhist = obj.x;
      
      obj.uRange = uRange;
      %obj.thetaMax = thetaMax;
      %obj.speed = speed;
      obj.dRange = dRange;
      obj.dims = dims;
    end
    
  end % end methods
end % end classdef
