#!/bin/bash

# Parameters
PROJECT_ROOT="./"
HEADER="$PROJECT_ROOT/temp"
cat > ${HEADER} <<- EOM
#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:XXX
#SBATCH --ntasks-per-node=XXX
#SBATCH --cpus-per-task=XXX
#SBATCH --constraint=XXX
#SBATCH --mem=XXX

module load anaconda3
module load NCCL/2.4.7-1-cuda.10.0
source activate multi
export NCCL_DEBUG=INFO
export PYTHONFAULTHANDLER=1
export NCCL_SOCKET_IFNAME=^docker0,lo
EOM

MAINSCRIPT="./finetune_video.py"

# create exp variant
FEAT_EXTRACT='False'
BATCH_SIZE=32
USE_SCALING='False'
NUM_EPOCHS=12
OPTIM_NAME='sgd'
HEAD_LR=0.0025
BASE_LR=0.00025
WEIGHT_DECAY=0.005
MOMENTUM=0.9
LR_GAMMA=0.05
USE_SCHEDULER='True'
LR_WARM_UP_EPOCHS=2
LR_MIL='6,10'
SCALE_JITTERING='True'
COLORJITTER='True'
MODEL='avc'
if [ -z "$6" ]
then
  VID_BASE_ARCH='r2plus1d_18' # r2plus1d_18, r2plus1d_34, s3d
else
  VID_BASE_ARCH=$6
fi
if [ -z "$7" ]
then
  AUD_BASE_ARCH='resnet18' # resnet18, resnet34, resnet18
else
  AUD_BASE_ARCH=$7
fi
PRETRAINED='False'
CLIP_LEN=32
MAX_TRAIN_CLIPS_PER_VID=10
MAX_VAL_CLIPS_PER_VID=10
NUM_WORKERS=10
if [ -z "$9" ]
then
  FOLDS='1'
else
  FOLDS=$9
fi
USE_MLP_HEAD='True'
if [ -z "$4" ]
then
  AUGTYPE=1
else
  AUGTYPE=$4
fi
if [ -z "$5" ]
then
  MLPTYPE=0
else
  MLPTYPE=$5
fi
if [ -z "$8" ]
then
  HEADCOUNT=1
else
  HEADCOUNT=$8
fi
echo $1 $2 $3  $4 $5 $6 $7 $8 $9

# command
for dataset in 'hmdb51'
do
    for lr in $HEAD_LR
    do    
        EXP_NAME="fin-$dataset-$3-jitter-$SCALE_JITTERING-clips-$MAX_TRAIN_CLIPS_PER_VID"
        EXP="$2/$EXP_NAME/$FOLDS"
        mkdir -p $EXP
        SCRIPT="${EXP}/launcher.sh"
        cp $HEADER $SCRIPT
        echo "
python3 $MAINSCRIPT \
--fold ${FOLDS} \
--output-dir $EXP \
--dataset $dataset \
--ckpt-epoch $3 \
--augtype ${AUGTYPE} \
--weights-path $1 \
--feature-extract ${FEAT_EXTRACT} \
--batch-size ${BATCH_SIZE} \
--epochs ${NUM_EPOCHS} \
--use-scaling ${USE_SCALING} \
--optim-name ${OPTIM_NAME} \
--head-lr $lr \
--base-lr ${BASE_LR} \
--momentum ${MOMENTUM} \
--weight-decay ${WEIGHT_DECAY} \
--use-scheduler ${USE_SCHEDULER} \
--lr-gamma ${LR_GAMMA} \
--lr-warmup-epochs ${LR_WARM_UP_EPOCHS} \
--lr-milestones ${LR_MIL} \
--model ${MODEL} \
--vid-base-arch ${VID_BASE_ARCH} \
--aud-base-arch ${AUD_BASE_ARCH} \
--pretrained ${PRETRAINED} \
--use-mlp ${USE_MLP_HEAD} \
--mlptype ${MLPTYPE} \
--headcount ${HEADCOUNT} \
--clip-len ${CLIP_LEN} \
--use-scale-jittering ${SCALE_JITTERING} \
--colorjitter ${COLORJITTER} \
--train-clips-per-video ${MAX_TRAIN_CLIPS_PER_VID} \
--val-clips-per-video ${MAX_VAL_CLIPS_PER_VID} \
--workers ${NUM_WORKERS}" >> $SCRIPT
        chmod +x $SCRIPT
        
        # launch experiment
        # $SCRIPT
        sbatch --job-name=$EXP_NAME --output=$EXP/%j.out --error=$EXP/%j.err "$SCRIPT"
    done
done
