JOBID=$1
if [ -z "$2" ]
then
  num=200 # 1 is old: cropsize=112, 3 is new: 224. automatically sets clip_len to 8, stride=4
else
  num=$2
fi
if [ -z "$3" ]
then
  AUGTYPE=1 # 1 is old: cropsize=112, 3 is new: 224. automatically sets clip_len to 8, stride=4
else
  AUGTYPE=$3
fi
if [ -z "$4" ]
then
  MLPTYPE=1 # 0: no sync-Bn, 1 is sync-bn
else
  MLPTYPE=$4
fi
if [ -z "$5" ]
then
  VID_BASE_ARCH='r2plus1d_18' # r2plus1d_18, r2plus1d_34, s3d
else
  VID_BASE_ARCH=$5
fi
if [ -z "$6" ]
then
  AUD_BASE_ARCH='resnet18' # resnet18, resnet34, resnet18
else
  AUD_BASE_ARCH=$6
fi
if [ -z "$7" ]
then
  HEADCOUNT=1 # 1 is old: cropsize=112, 3 is new: 224
else
  HEADCOUNT=$7
fi
echo $JOBID
echo $num
echo $AUGTYPE
echo $MLPTYPE
echo $VID_BASE_ARCH
echo $AUD_BASE_ARCH

TARGETDIR="./outfiles/${JOBID}"
OUT_DIR=$(ls ${TARGETDIR})
OUTPUT_DIR="./outfiles/${JOBID}/${OUT_DIR}"
echo $OUTPUT_DIR

echo "Launching eval task at checkpoint ${num} at "; date
# N_WEIGHTS_PATH="${TARGETDIR}/${OUT_DIR}/checkpoints/checkpoint.pth"
N_WEIGHTS_PATH="${TARGETDIR}/${OUT_DIR}/checkpoints/ckpt_${num}.pth"
echo ${N_WEIGHTS_PATH}
fold='1'
bash finetuning_scripts/hmdb_51_finetune.sh ${N_WEIGHTS_PATH} ${OUTPUT_DIR} ${num} ${AUGTYPE} ${MLPTYPE} ${VID_BASE_ARCH} ${AUD_BASE_ARCH} ${HEADCOUNT} $fold
bash finetuning_scripts/ucf_101_finetune.sh ${N_WEIGHTS_PATH} ${OUTPUT_DIR} ${num} ${AUGTYPE} ${MLPTYPE} ${VID_BASE_ARCH} ${AUD_BASE_ARCH} ${HEADCOUNT} $fold
