#!/bin/bash

# Parameters
#SBATCH --constraint=XXX
#SBATCH --cpus-per-task=XXX
#SBATCH --error=XXX
#SBATCH --gres=gpu:XXX
#SBATCH --job-name=XXX
#SBATCH --mem=XXX
#SBATCH --nodes=XXX
#SBATCH --ntasks-per-node=XXX
#SBATCH --open-mode=XXX
#SBATCH --output=XXX
#SBATCH --partition=XXX
#SBATCH --signal=XXX
#SBATCH --time=XXX
#SBATCH --mail-user=XXX
#SBATCH --mail-type=END,FAIL,REQUEUE,BEGIN


source activate gdt

export MASTER_ADDR=${SLURM_NODELIST:0:9}${SLURM_NODELIST:10:4}
export MASTER_PORT=19500

# debugging flags (optional)
export NCCL_DEBUG=INFO
export PYTHONFAULTHANDLER=1

# set the network interface
export NCCL_SOCKET_IFNAME=^docker0,lo
echo $SLURMD_NODENAME $SLURM_JOB_ID $CUDA_VISIBLE_DEVICES

SAV_FOLDER="XXX"
mkdir -p ${SAV_FOLDER}
DS='kinetics'
MUM_EPOCHS=201
MOMENTUM=0.9
WEIGHT_DECAY=1e-5
USE_SCHEDULER='True'
SCHEDULER_TYPE='multi_step'
LR_GAMMA=0.1
LR_WARM_EPOCHS=10
LR_MIL='251'
MODEL='avc'
USE_MLP_HEAD='True'
VID_BASE_ARCH='r2plus1d_18'
PRETRAINED='False'
MLPTYPE=0
NUM_CLIPS=1
AUGTYPE=1
NUM_WORKERS=10
NCE_T=0.07
WARM_BN='False'
SYNC_BN='True'
DUALDATA='True'
TARGET_FPS=30
CLIP_LEN=30
CROP_SIZE=112
SAMPLE_RATE=1
BATCH_SIZE=8
LR=0.66666666667e-2
HEADCOUNT=2
TWOHEAD=3
ASYNCED=-1
ARROWTIME=0
COLORJITTER='False'
NUM_NEGATIVES=-1

# AUDIO AUGS
AUD_BASE_ARCH='resnet9'
AUG_AUDIO='True'
SAMPLE_AUD_IND='False'
AUD_AUG_TYPE='medium'
AUD_SAMPLE_RATE=24000
AUD_SPEC_TYPE=2
AUD_VOLUME_JITTERING='True'
AUD_TEMPORAL_JITTERING='False'
AUD_NUM_SEC=1
AUD_Z_NORMALIZE='True'


# command
srun --label python3 main_av_gdt.py \
--output-dir ${SAV_FOLDER} \
--dataset ${DS} \
--batch-size ${BATCH_SIZE} \
--epochs ${MUM_EPOCHS} \
--lr ${LR} \
--momentum ${MOMENTUM} \
--weight-decay ${WEIGHT_DECAY} \
--use-scheduler ${USE_SCHEDULER} \
--scheduler-type ${SCHEDULER_TYPE} \
--lr-gamma ${LR_GAMMA} \
--lr-warmup-epochs ${LR_WARM_EPOCHS} \
--lr-milestones ${LR_MIL} \
--warmup-bn ${WARM_BN} \
--sync-bn ${SYNC_BN} \
--model ${MODEL} \
--vid-base-arch ${VID_BASE_ARCH} \
--aud-base-arch ${AUD_BASE_ARCH} \
--pretrained ${PRETRAINED} \
--mlptype ${MLPTYPE} \
--augtype ${AUGTYPE} \
--target-fps ${TARGET_FPS} \
--clip-len ${CLIP_LEN} \
--train-crop-size ${CROP_SIZE} \
--sample-rate ${SAMPLE_RATE} \
--clips-per-video ${NUM_CLIPS} \
--workers ${NUM_WORKERS} \
--nce-t ${NCE_T} \
--use-mlp ${USE_MLP_HEAD} \
--aug-audio ${AUG_AUDIO} \
--sample-aud-ind ${SAMPLE_AUD_IND} \
--headcount ${HEADCOUNT} \
--audio-augtype ${AUD_AUG_TYPE} \
--arrowtime ${ARROWTIME} \
--colorjitter ${COLORJITTER} \
--num-negatives ${NUM_NEGATIVES} \
--asynced ${ASYNCED} \
--dualdata ${DUALDATA} \
--twohead ${TWOHEAD} \
--aud-sample-rate ${AUD_SAMPLE_RATE} \
--aud-spec-type ${AUD_SPEC_TYPE} \
--use-volume-jittering ${AUD_VOLUME_JITTERING} \
--use-temporal-jittering ${AUD_TEMPORAL_JITTERING} \
--num-sec ${AUD_NUM_SEC} \
--z-normalize ${AUD_Z_NORMALIZE} \

