(define (domain termes)
    (:requirements :typing :negative-preconditions)
    (:types
        numb - object
        position - object
    )

    (:predicates
        (height ?p - position ?h - numb)
        (at ?p - position)
        (has-block)
        ;
        ; static predicates
        (SUCC ?n1 - numb ?n2 - numb)
        (NEIGHBOR ?p1 - position ?p2 - position)
        (IS-DEPOT ?p - position)
    )

    (:action move
        :parameters (?from - position ?to - position ?h - numb)
        :precondition (and
            (at  ?from)
            (NEIGHBOR ?from ?to)
            (height ?from ?h)
            (height ?to ?h)
        )
        :effect (and
            (not (at  ?from))
            (at  ?to)
        )
    )

    (:action move-up
        :parameters (?from - position ?hfrom - numb ?to - position ?hto - numb)
        :precondition (and
            (at  ?from)
            (NEIGHBOR ?from ?to)
            (height ?from ?hfrom)
            (height ?to ?hto)
            (SUCC ?hto ?hfrom)
        )
        :effect (and
            (not (at  ?from))
            (at  ?to)
        )
    )

    (:action move-down
        :parameters (?from - position ?hfrom - numb ?to - position ?hto - numb)
        :precondition (and
            (at  ?from)
            (NEIGHBOR ?from ?to)
            (height ?from ?hfrom)
            (height ?to ?hto)
            (SUCC ?hfrom ?hto)
        )
        :effect (and
            (not (at  ?from))
            (at  ?to)
        )
    )

    (:action place-block
        :parameters (?rpos - position ?bpos - position ?hbefore - numb ?hafter - numb)
        :precondition (and
            (at  ?rpos)
            (NEIGHBOR ?rpos ?bpos)
            (height ?rpos ?hbefore)
            (height ?bpos ?hbefore)
            (SUCC ?hafter ?hbefore)
            (has-block)
	    (not (IS-DEPOT ?bpos))
        )
        :effect (and
            (not (height ?bpos ?hbefore))
            (height ?bpos ?hafter)
            (not (has-block))
        )
    )

    (:action remove-block
        :parameters (?rpos - position ?bpos - position ?hbefore - numb ?hafter - numb)
        :precondition (and
            (at  ?rpos)
            (NEIGHBOR ?rpos ?bpos)
            (height ?rpos ?hafter)
            (height ?bpos ?hbefore)
            (SUCC ?hbefore ?hafter)
            (not (has-block))
        )
        :effect (and
            (not (height ?bpos ?hbefore))
            (height ?bpos ?hafter)
            (has-block)
        )
    )

    (:action create-block
        :parameters (?p - position)
        :precondition (and
            (at  ?p)
            (not (has-block))
            (IS-DEPOT ?p)
        )
        :effect (and
            (has-block)
        )
    )

    (:action destroy-block
        :parameters (?p - position)
        :precondition (and
            (at  ?p)
            (has-block)
            (IS-DEPOT ?p)
        )
        :effect (and
            (not (has-block))
        )
    )


)
