# Supplementary Materials

website link https://91b1e4d5bd3a.github.io/
![Trajectory Visualization](vis_traj.png)



## Install this repo

```bash
cd <path to this repo>
pip install -e . 
```
You would need to setup your OPENAI_API_KEY or ANTHROPIC_API_KEY in your environment variables.

```shell
export OPENAI_API_KEY="your keys"
```

## Installation val (for PDDL validation)

```bash
cd submodule/VAL
make clean
sed -i 's/-Werror //g' Makefile
make -j2
#the validate file should be generated after make
```

## Commands

### PDDL

You could run all classical planning tasks with:

```bash
./PDDL/gen_plan_pddl_val.sh
```

or run selected task through:


Prompt generation 
By default this would generate the prompt in 'data' folder
```bash
python llm_plan_bench/models/prompt_generation/generate_plan_prompt.py \
--data_path ./PDDL_dataset \
--output_path ./data \
```

LLM Plan generation
for model_path currently just use llama (huggingface/Llama-3.1-8B-Instruct)

```bash
python PDDL/solve_plans.py \
--input ./data/inputs/solve_plan/<selected_task>.json \
--output ./experiments/<output folder name> \
--model_path <>
```

Validator
The solution path should be the path to the pddl format solution

```bash
python PDDL/validate_plans.py \
--data_path ./data/pddl \
--solutions_path ./experiments/<output folder name>/pddl 
--domain <Specific domain to validate (by default for all domains)>
```


### Games

#### 1. Tic Tac Toe

```shell
cd game
python ttt.py
```

#### 2. Connect Four

```shell
cd game
python cf.py
```

#### 3. Chess

```shell
cd game
python chess_simplify.py
```

#### 4. Hanabi

You can refer to file hanabi-config.json to change the configuration of the game, including models, player number, and log dir.

```shell
cd game
python hanabi.py
```

#### 5. Tic Tac Toe against solver

```shell
cd game
python ttt_solver.py
```

#### 6. Connect Four against solver

```shell
cd game/connect4
make
cp c4solver ..
cd ..
python c4solver.py
```

Then edit the url in `cf_vs_solver.py`, then

```shell
python cf_vs_solver.py
```

#### 7. Chess against stockfish

You have to first download the stockfish software

```shell
python chess_stockfish.py
```
