import subprocess
import time

if __name__ == "__main__":
    # Set these variables before running this file to the GPUs and cpu ranges accessible for your device.
    # Example ranges and parameters have been given
    GPUS = [1,4,5,6,7]
    taskset_range = ["0-10", "10-20", "20-30", "30-40", "40-50"]
    python = "/path/to/python"
    cores = 6
    # End of variables to set

    jobs = []
    for model in ["davinci", "gpt-3.5-turbo", "curie", "babbage", "ada", "tiiuae/falcon-7b", "tiiuae/falcon-7b-instruct", 
                  "meta-llama/Llama-2-7b-chat-hf", "meta-llama/Llama-2-13b-chat-hf", "meta-llama/Llama-2-7b-hf", 
                  "meta-llama/Llama-2-13b-hf", "gpt-3.5-turbo-instruct", "codellama/CodeLlama-7b-hf", "decapoda-research/llama-7b-hf", 
                  "decapoda-research/llama-13b-hf", "helloollel/vicuna-13b", "helloollel/vicuna-7b"]:
        for dataset in ["AGNews", "eli5", "SST", "goemotions"]:
            jobs.append(f"{python} scripts/meta.py {model} --title {dataset} --parent_dir2 {dataset} --cores {cores}")


    processes = [None for _ in range(len(GPUS))]
    current_job = 0
    while True:
        for i, process in enumerate(processes):
            if process is None or process.poll() is not None:
                if current_job < len(jobs):
                    print(f"Starting job {current_job}")
                    processes[i] = subprocess.Popen(["taskset", "-c", taskset_range[i]] + jobs[current_job].split() 
                                                    , env={"CUDA_VISIBLE_DEVICES": str(GPUS[i])}, )
                    current_job += 1
        
        time.sleep(10)