import glob
import os
import argparse
import random

DATASET = "java"

def run(inp_cmd):
    print(inp_cmd)
    os.system(inp_cmd)


# script to run test, val, train of CNNDM dataset example: python run_sh.py  --mode train --baseline False
if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--mode', choices=["train", "test", "val", "only_eval"])
    parser.add_argument('--baseline', default="True", choices=["True", "False"])
    parser.add_argument('--gpu', default="0,1,2,3,4,5,6,7")
    parser.add_argument('--dataset', default="java", choices=["python", "java"])
    parser.add_argument('--model_name', default="pretrained_weights/java_codet5_base")
    parser.add_argument('--batch_size', default=32)
    # no need to set in training mode
    parser.add_argument('--save_path', default="")  # dir/contains/checkpoints
    args = parser.parse_args()

    DATASET = args.dataset
    args.model_name = args.model_name.replace("java", args.dataset)
    inference_param = " --diversity_pen 3.5 --beam_size 12 --min_length 0 --max_length 128 --length_pen 1.0 --no_repeat_ngram 10 "
    if args.mode != "train":
        test_cmd = f"python inference_fast.py --start_gpu 0 --split_num 3 --dataset {DATASET} " \
                   f" --baseline True --mode {args.mode} --batch_size {args.batch_size}" \
                   f" --model_name {args.model_name} " \
                   f" --save_path {args.save_path} --PTM codet5 "
        test_cmd = test_cmd + inference_param
        run(test_cmd)
    else:
        num_process = len(args.gpu.split(','))
        # distributed
        train_cmd = f"CUDA_VISIBLE_DEVICES={args.gpu}" \
                    f" python -m torch.distributed.launch --master_port 2950{random.randint(0, 9)} --nproc_per_node={num_process} " \
                    f" train_distributed.py --save_path checkpoints/{DATASET}/{args.model_name} " \
                    f" --max_src_len 512 --max_tgt_len 128 " \
                    f" --mode train --accum_count 1 -lr 0.001 --batch_size {args.batch_size} --n_epochs 10 " \
                    f" --save_steps 1000 --dataset {DATASET} --PTM codet5 --model_name {args.model_name} "
        train_cmd = train_cmd + inference_param
        run(train_cmd)
