import glob
import os
import argparse
import random

DATASET = "wiki_bio"
T5_PTM_PATH = "pretrained_weights/wiki_bio_t5_small"

def run(inp_cmd):
    print(inp_cmd)
    os.system(inp_cmd)


# script to run test, val, train of wikibio dataset example: python run_sh.py  --mode train --baseline False
if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--mode', choices=["train", "test", "val"])
    parser.add_argument('--baseline', default="True", choices=["True", "False"])
    parser.add_argument('--gpu', default="0,1,2,3,4,5,6,7")
    parser.add_argument('--model_name', default="t5-small")
    parser.add_argument('--batch_size', default=8)
    # no need to set in training mode
    parser.add_argument('--save_path', default="")  # dir/contains/checkpoints
    args = parser.parse_args()
    if args.baseline == "False":
        args.model_name = T5_PTM_PATH

    inference_param = "--diversity_pen 1.0 --beam_size 12 --max_length 128 --min_length 40 "
    if args.mode != "train":
        test_cmd = f"python inference_fast.py --start_gpu 0 --split_num 8 --dataset {DATASET} " \
                   f" --mode {args.mode} --batch_size {args.batch_size} " \
                   f" --model_name {args.model_name} " \
                   f" --save_path {args.save_path} --PTM t5 "
        test_cmd = test_cmd + inference_param
        run(test_cmd)
    else:
        num_process = len(args.gpu.split(','))
        # distributed
        train_cmd = f"CUDA_VISIBLE_DEVICES={args.gpu}" \
                    f" python -m torch.distributed.launch --master_port 2950{random.randint(0,9)} --nproc_per_node={num_process} " \
                    f" train_distributed.py --save_path checkpoints/wiki_bio/{args.model_name} " \
                    f" --max_src_len 512 --max_tgt_len 128 " \
                    f" --mode train --accum_count 1  --batch_size {args.batch_size} --n_epochs 50 " \
                    f" --save_steps 12000 --dataset {DATASET} --PTM t5 --model_name {args.model_name} "
        train_cmd = train_cmd + inference_param
        run(train_cmd)
