import glob
import os
import argparse
import random

DATASET = "totto_meta"
T5_PTM_PATH = "pretrained_weights/totto_meta_t5_base"


def run(inp_cmd):
    print(inp_cmd)
    os.system(inp_cmd)


# script to run test, val, train of CNNDM dataset example: python run_sh.py  --mode train --baseline False
if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--mode', choices=["train", "test", "val", "only_eval"])
    parser.add_argument('--baseline', default="True", choices=["True", "False"])
    parser.add_argument('--gpu', default="0,1,2,3,4,5,6,7")
    parser.add_argument('--model_name', default="t5-small")
    parser.add_argument('--batch_size', default=32)
    # no need to set in training mode
    parser.add_argument('--save_path', default="")  # dir/contains/checkpoints
    args = parser.parse_args()
    if args.baseline == "False":
        args.model_name = T5_PTM_PATH
    inference_param = "--diversity_pen 1.0 --beam_size 12 --min_length 10 --length_pen 2.0  --max_length 70 "

    if args.mode != "train":
        test_cmd = f"python inference_fast.py --start_gpu {args.gpu} --split_num 4 --dataset {DATASET} " \
                   f" --baseline True --mode {args.mode} --batch_size {args.batch_size}" \
                   f" --model_name {args.model_name}  --PTM t5  --save_path {args.save_path} "
        test_cmd = test_cmd + inference_param
        run(test_cmd)
    else:
        num_process = len(args.gpu.split(','))
        # distributed
        train_cmd = f"CUDA_VISIBLE_DEVICES={args.gpu}" \
                    f" python -m torch.distributed.launch --master_port 2950{random.randint(0,9)} --nproc_per_node={num_process} " \
                    f" train_distributed.py --save_path checkpoints/{DATASET}/{args.model_name} " \
                    f" --max_src_len 512 --max_tgt_len 128" \
                    f" --mode train --accum_count 1 -lr 0.001 --batch_size {args.batch_size} --n_epochs 10 " \
                    f" --save_steps 500 --dataset {DATASET} --PTM t5 --model_name {args.model_name} "
        train_cmd = train_cmd + inference_param
        run(train_cmd)
