import glob
import os
import argparse
import random

DATASET = "xsum"
PEGA_PTM_PATH = "google/pegasus-xsum"
T5_PTM_PATH = "pretrained_weights/xsum_t5_small"


def run(inp_cmd):
    print(inp_cmd)
    os.system(inp_cmd)


# script to run test, val, train of CNNDM dataset example: python run_sh.py  --mode train --baseline False
if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--mode', choices=["train", "test", "val"])
    parser.add_argument('--baseline', default="False", choices=["True", "False"])
    parser.add_argument('--gpu', default="0,1,2,3,4,5,6,7")
    parser.add_argument('--model_name', default="t5-small")
    parser.add_argument('--batch_size', default=16)
    # no need to set in training mode
    parser.add_argument('--save_path', default="")  # dir/contains/checkpoints
    args = parser.parse_args()

    if args.baseline == "False":
        if args.model_name == "t5-small":
            args.model_name = T5_PTM_PATH
        else:
            args.model_name = PEGA_PTM_PATH

    inference_param = f"  --alpha 0.5 --length_pen 0.8  --max_length 80 --min_length 0 "
    if args.mode != "train":
        test_cmd = f"python inference.py --start_gpu {args.gpu} --split_num 4 --dataset {DATASET} " \
                   f" --batch_size {args.batch_size} --model_name {args.model_name} " \
                   f" --mode {args.mode} --PTM t5 --save_path {args.save_path}  --beam_size 8 --diversity_pen 0.0 --early_stop True "
        # f" --from_pretrained True --PTM pegasus  --model_name {PEGA_PTM_PATH} " \
        test_cmd = test_cmd + inference_param
        run(test_cmd)

    else:
        num_process = len(args.gpu.split(','))
        # distributed
        train_cmd = f"CUDA_VISIBLE_DEVICES={args.gpu} " \
                    f" python -m torch.distributed.launch --master_port 2950{random.randint(0, 9)} --nproc_per_node={num_process} " \
                    f" train_distributed.py --save_path checkpoints/{DATASET}/{args.model_name} " \
                    f" --max_src_len 512 --max_tgt_len 128   --baseline {args.baseline}  --beam_size 1 --diversity_pen 2.8 " \
                    f" --mode train --accum_count 1  --batch_size {args.batch_size} --n_epochs 3 " \
                    f" --save_steps 2000 --dataset {DATASET} --PTM t5  --model_name {args.model_name} "
        train_cmd = train_cmd + inference_param
        run(train_cmd)
