
# run similarity experiments (Fig.1)
CUDA_VISIBLE_DEVICES=0 python3 experiments/similarity.py --dataset=diabetes --lr=0.05 --model=logistic_regression --num_classes=2 --clipping_norm=1.0 --epsilon=1 --delta=0.00005 --budget=50 --random_seed=0

# run budget experiments (Fig.2 middle-right)
CUDA_VISIBLE_DEVICES=0 python3 experiments/budget.py --dataset=diabetes --model=logistic_regression --num_classes=2 --clipping_norm=1.0 --epsilon=10 --delta=0.00005 --budget=120 --num_players=400 --random_seed=0

# run comparison between iid and corr. noise (Fig.2 right-most)
CUDA_VISIBLE_DEVICES=0 python3 experiments/momentum.py --dataset=diabetes --model=logistic_regression --num_classes=2 --clipping_norm=1.0 --epsilon=10 --delta=0.00005 --budget=50 --num_players=400 --use_momentum --random_seed=0
CUDA_VISIBLE_DEVICES=0 python3 experiments/momentum.py --dataset=diabetes --model=logistic_regression --num_classes=2 --clipping_norm=1.0 --epsilon=10 --delta=0.00005 --budget=50 --num_players=400 --random_seed=0
CUDA_VISIBLE_DEVICES=0 python3 experiments/momentum.py --dataset=diabetes --model=logistic_regression --num_classes=2 --budget=50 --num_players=400 --random_seed=0

# run noisy label detection task (Fig.3 & 4) for different semivalues (Tab.2)
CUDA_VISIBLE_DEVICES=0 python3 experiments/label_flip.py --dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10 --epsilon=1 --delta=0.00005 --budget=1000 --num_players=800 --random_seed=0
CUDA_VISIBLE_DEVICES=0 python3 experiments/label_flip.py --dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10 --clipping_norm=1.0 --epsilon=1 --delta=0.00005 --budget=1000 --num_players=800 --use_momentum --random_seed=0
CUDA_VISIBLE_DEVICES=0 python3 experiments/label_flip.py --dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10 --clipping_norm=1.0 --epsilon=1 --delta=0.00005 --budget=1000 --num_players=800 --random_seed=0

# run dataset valuation on noisy label detection task (Tab.3)
CUDA_VISIBLE_DEVICES=0 python3 experiments/dataset_val.py --flip_method=label--dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10 --epsilon=1.0 --delta=0.00005 --budget=200 --num_players=800 --dataset_size=8 --random_seed=0
CUDA_VISIBLE_DEVICES=0 python3 experiments/dataset_val.py --flip_method=label --dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10 --clipping_norm=1.0 --epsilon=1.0 --delta=0.00005 --budget=200 --num_players=800 --dataset_size=8 --use_momentum --random_seed=0
CUDA_VISIBLE_DEVICES=0 python3 experiments/dataset_val.py --flip_method=label --dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10 --clipping_norm=1.0 --epsilon=1.0 --delta=0.00005 --budget=200 --num_players=800 --dataset_size=8 --random_seed=0

# run FL (Tab.3)
CUDA_VISIBLE_DEVICES=0 python3 experiments/fl.py --warmup_ratio=0 --lr=0.001 --dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10 --epsilon=1.0 --delta=0.00005 --budget=50 --num_players=50 --dataset_size=32 --random_seed=0
CUDA_VISIBLE_DEVICES=0 python3 experiments/fl.py --warmup_ratio=0 --lr=0.001 --dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10  --clipping_norm=1.0 --epsilon=1.0 --delta=0.00005 --budget=50 --num_players=50 --dataset_size=32 --use_momentum  --random_seed=0
CUDA_VISIBLE_DEVICES=0 python3 experiments/fl.py --warmup_ratio=0 --lr=0.001 --dataset=mnist --flip_ratio=0.3 --model=cnn --num_classes=10  --clipping_norm=1.0 --epsilon=1.0 --delta=0.00005 --budget=50 --num_players=50 --dataset_size=32 --random_seed=0
