import numpy as np
import torch

def perturb_labels(subset, flip_ratio):
    # perturb labels of subset
    num_data = len(subset.indices)
    num_flipped = int(flip_ratio * num_data)
    print(f"flipping {num_flipped} labels")
    indices = np.arange(num_flipped)
    for idx in indices:
        dataset_idx = subset.indices[idx]
        # get the total number of classes
        # if label is an attribute of the dataset
        if hasattr(subset.dataset, 'label'):
            classes = np.unique(subset.dataset.label)
            subset.dataset.label[dataset_idx] = np.random.choice(classes[classes != subset.dataset.label[dataset_idx]])
        # otherwise if target is an attribute of the dataset
        elif hasattr(subset.dataset, 'targets'):
            classes = np.unique(subset.dataset.targets)
            subset.dataset.targets[dataset_idx] = np.random.choice(classes[classes != int(subset.dataset.targets[dataset_idx])])
        else:
            raise Exception("Cannot find label/targets attribute in dataset; Failed to perturb labels")
    return subset
