import torch
from typing import Callable, Optional
from opacus.validators import ModuleValidator
from opacus import PrivacyEngine
from opacus.optimizers.optimizer import DPOptimizer


def make_valid(model):
    model = ModuleValidator.fix(model)
    validator = ModuleValidator()
    errors = validator.validate(model, strict=False)
    print(f"found errors: {errors}")
    return model


def make_private(model, optimizer, train_loader, num_iters, epsilon, delta, clipping_norm):
    def step_momentum(self, closure: Optional[Callable[[], float]] = None, player=None, step=None) -> Optional[float]:
        if closure is not None:
            with torch.enable_grad():
                closure()

        if self.pre_step():
            return self.original_optimizer.step(player=player, step=step)
        else:
            return None
    
    # monkey patch the step method
    setattr(DPOptimizer, 'step_momentum', step_momentum)

    privacy_engine = PrivacyEngine()
    model, optimizer, train_loader = privacy_engine.make_private_with_epsilon(
        module=model,
        optimizer=optimizer,
        data_loader=train_loader,
        epochs=num_iters,
        target_epsilon=epsilon,
        target_delta=delta,
        max_grad_norm=clipping_norm,
    )

    return privacy_engine, model, optimizer, train_loader
