import torch


def optimizer_to_(optim, device):
    for param in optim.state.values():
        # Not sure there are any global tensors in the state dict
        if isinstance(param, torch.Tensor):
            param.data = param.data.to(device)
            if param._grad is not None:
                param._grad.data = param._grad.data.to(device)
        elif isinstance(param, dict):
            for subparam in param.values():
                if isinstance(subparam, torch.Tensor):
                    subparam.data = subparam.data.to(device)
                    if subparam._grad is not None:
                        subparam._grad.data = subparam._grad.data.to(device)


def lr_scheduler_to_(scheduler, device):
    for key, value in scheduler.__dict__.items():
        if key != 'optimizer':
            if isinstance(value, torch.Tensor):
                value.data = value.data.to(device)
