# Variance Reduction of Stochastic Hypergradient Estimation by Mixed Fixed-Point Iteration

This repository contains the anonymous supplemental material for the reproduction of the experiments presented in the paper:

**"Variance Reduction of Stochastic Hypergradient Estimation by Mixed Fixed-Point Iteration"**

## Tested Environments
- **CPU**: Intel Core i7-8700 @ 3.20GHz (6 cores, 12 threads)
- **Memory**: 32GB RAM
- **GPU**: NVIDIA RTX A6000 (48GB VRAM)
  - CUDA Driver Version: 550.144.03
  - CUDA Runtime Version: 12.4
- **OS**: Ubuntu 24.04 LTS 
- **Python**: 3.10.16

## Setup
Install the required dependencies:
```bash
pip install -r requirements.txt
```

## Experiments

### Section 5.1: Effect of Mixing Rate

To reproduce the experiments in Section 5.1 (tuning alpha and scale parameters):

```bash
python main.py MainPipeline conf.paper_tune_alpha_and_scale
```

**Plots**: Results can be visualized using the notebook `notebooks/main_tune_alpha_and_scale.ipynb`

### Section 5.2: Comparison with Existing Approaches

To reproduce the benchmark experiments in Section 5.2:

```bash
# Fashion-MNIST dataset
python main.py MainPipeline conf.paper_fashion

# Adult dataset
python main.py MainPipeline conf.paper_adult

# California housing dataset
python main.py MainPipeline conf.paper_california

# Synthetic dataset
python main.py MainPipeline conf.paper_synth
```

**Plots**: Results can be visualized using the notebook `notebooks/main_benchmark.ipynb`

### Appendix: Hyperparameter Optimization

For additional bilevel optimization experiments:

```bash
python main.py BilevelOptimizationPipeline conf.app_adult
```

## Visualization

Results and plots are generated using Jupyter notebooks in the `notebooks/` directory:

- `main_tune_alpha_and_scale.ipynb` - Plots for Section 5.1
- `main_benchmark.ipynb` - Plots for Section 5.2
- `app_bo.ipynb` - Plots for Appendix
