# Generating Views
We take CIFAR100 for examples.
## VG1
We need to `cd` to the `cifar10` directory.
```bash
python3 generate_datasets_c100.py --eps1 0.2 --eps2 0.35 \
    --iters 600 --lam2 0.01 \
    --objective norm --loss_type l2 --clamp --eval \
    --dest_data_path data_c100/c100_vg1.pkl \
    --batch_size 8 --n 8 --init_noise_scale 0.02 
```
## VG2
We need to `cd` to the `cifar10` directory.
```bash
python3 generate_datasets_c100.py --init_noise_scale 0.2 \
    --add_noise --iters 0 --clamp --eval \
    --dest_data_path data_c100/c100_vg2.pkl \
    --batch_size 8
```

# Train SimCLR with Generated Views

## CIFAR10: VG1 + A2
We need to `cd` to the `cifar10` directory.
```bash
python3 main2.py \
--path_dir 'logs/C10_VG1+A2' \
--wandb_project 'simclr-cifar10' \
--bsz=128 --epochs 800 \
--fp16 --loss='simclr' --which_loss='A2' \
--use_view_generator --which_view_generator='cache' \
--view_paths='data/c10_vg1.pkl' \
--n_views_gan=1 
```

## CIFAR100: VG1 + A2
We need to `cd` to the `cifar100` directory.
```bash
python main2_supcon.py \
--log_dir 'logs/C100_VG4+A2' \
--append_view --pos_view_paths '../cifar10/data_c100/c100_vg1.pkl' \
--learning_rate 0.5   --temp 0.5 --alpha 0.5 \
--cosine   --method 'A2'  \
--batch_size 512 --epochs 1200 
```
