export OMP_NUM_THREADS=1
export OPENBLAS_NUM_THREADS=1
source ~/.bashrc

patients=(0 1 2 3 4 5 6 7 8 9 14 16 17 18 19 20 21 23)


for ((i = 0; i < ${#patients[@]}; i++))
do
  patient_id=${patients[i]}
  python -u ~/DMNet_PUBLIC/utils/generate_channel_level_reference.py --patient_id ${patient_id} --segment_length 150  > ./logs/ssp_"$i".log  2>&1 &
  wait
done


python -u ~/DMNet/model.py  --exp_id 1 --gpu_id 1  > ./logs/hp_sl_150_sn_5_sul_5_exp_1.log 2>&1 &
python -u ~/DMNet/model.py --exp_id 2 --gpu_id 2  > ./logs/hp_sl_150_sn_5_sul_5_exp_2.log 2>&1 &
python -u ~/DMNet/model.py --exp_id 3 --gpu_id 3  > ./logs/hp_sl_150_sn_5_sul_5_exp_3.log 2>&1 &
python -u ~/DMNet/model.py --exp_id 4 --gpu_id 1  > ./logs/hp_sl_150_sn_5_sul_5_exp_4.log 2>&1 &
python -u ~/DMNet/model.py --exp_id 5 --gpu_id 2  > ./logs/hp_sl_150_sn_5_sul_5_exp_5.log 2>&1 &
python -u ~/DMNet/model.py --exp_id 6 --gpu_id 3  > ./logs/hp_sl_150_sn_5_sul_5_exp_6.log 2>&1 &
wait

