import matplotlib.pyplot as plt
import pickle
import os
import json
from datetime import datetime
import torch

def plot_rewards(reward_dict):

    for i, (key, val) in enumerate(reward_dict.items()):
        plt.subplot(2, len(reward_dict)//2 + len(reward_dict)%2, i+1)
        plt.plot(val)
        plt.title(key)
    
    plt.savefig("results/result.png")
    
   
def dump_output(reward_dict, path):
    with open(path, 'wb') as file:
        pickle.dump(reward_dict, file)  

def dump_settings(settings_dict, path):
    with open(path, 'w') as file:
        json.dump(settings_dict, file, indent=4) 
        
def save_model(model, path):
    torch.save(model, path)  
        
        
def get_result_folder(exp):
    dt = datetime.now()
    foldername = str(dt).split()[1].split('.')[0]
    os.makedirs(f"results/{exp}/{foldername}/", exist_ok=False)
    return f"results/{exp}/{foldername}/"
#     os.makedirs(f"results/{exp}/", exist_ok=False)
#     return f"results/{exp}/"
        
def get_result_path(path):
    filename, extension = os.path.splitext(path)
    counter = 1

    while os.path.exists(path):
        path = filename + "(" + str(counter) + ")" + extension
        counter += 1

    return path             
