import numpy as np
from numpy.linalg import norm
import math

def find_angle(v1, v2):
    cos_v1_v2 = v1.dot(v2)/norm(v1)/norm(v2)
    clipped_cos = min(1., cos_v1_v2)
    return math.degrees(math.acos(clipped_cos))

def direction(gs, fs, ths, active_const, delta, epsilon=1e-15):
    assert len(gs) == len(fs) == len(ths)+1
    ths.append(1e6)
    k = len(gs)
    for i in range(k):
        if i==k-1 or fs[i] < ths[i]:
            if i != 0:
                pass
#                 print("Skipped an objective !!!")
#             print(f"Objective {i} is below threshold, so to be optimized")
            g = gs[i]
            for j in range(i):
                if (active_const and fs[j] > ths[j]) or g.dot(gs[j]) >= norm(g)*norm(gs[j])*math.sin(delta):
                    pass
                else:
                    print(f"It needs to be projected onto hyperplane of objective {j}")
                    g = projectCone(g, gs[j],delta)
#                     print(f"The new g is {g}, with norm {norm(g)}, and the angle between g and g_{j}={find_angle(g,gs[j])}")
            for j in range(i+1):
                if not (active_const and fs[j] > ths[j]) and g.dot(gs[j]) < norm(g)*norm(gs[j])*(math.sin(delta) - 1e-6):
#                     print(g.dot(gs[j]), norm(g)*norm(gs[j])*math.sin(delta))
                    return None
            return g
    
            
            
def projectCone(g, a, delta):
    '''
    a: Axis of the cone
    g: Vector to project
    
    p' = g + \alpha a
    \alpha = |g| * (sin(\gamma)*tan(\delta) - cos(\gamma))
    \gamma = angle between g and a
    \delta = pi/2-central_angle_of_cone
    '''
#     print(f"90-Delta is : {90 - math.degrees(delta)}")
#     print(f"Angle between g and a is: {find_angle(g,a)}")
    tan_delta = math.tan(delta)
    norm_a = norm(a)
    norm_g = norm(g)
    cos_gamma = g.dot(a)/norm_g/norm_a
    if cos_gamma > math.cos(delta):
        raise Exception
    sin_gamma = np.sqrt(1-cos_gamma**2)
#     print(cos_gamma, sin_gamma, cos_gamma**2 + sin_gamma**2, math.degrees(math.asin(sin_gamma)), math.degrees(math.asin(cos_gamma))) 
    alpha = norm_g * (tan_delta*sin_gamma - cos_gamma) / norm_a
    p_cone = g + alpha*a
    
    p_grad = norm_g * (cos_gamma*math.sin(delta) + sin_gamma*math.cos(delta))/norm(p_cone) * p_cone
#     print(f"Angle between pcone and a: {find_angle(p_cone, a)}")
    return p_grad