## Seeking Global Flat Minima in Federated Domain Generalization via Constrained Adversarial Augmentation

## Dependencies

```shell
python 3.9
torch 1.11.0
torchvision 0.12.0
```

## Prepare datasets

- Download the datasets ([PACS](https://drive.google.com/uc?id=1JFr8f805nMUelQWWmfnJR3y4_SYoN5Pd), [Digits-DG](https://drive.usercontent.google.com/download?id=15V7EsHfCcfbKgsDmzQKj_DfXt_XYp_P7&export=download&authuser=0), [OfficeHome](https://drive.google.com/uc?id=1uY0pj7oFsjMxRwaD3Sxy0jgel0fsYXLC), [TerraIncognita](https://lilablobssc.blob.core.windows.net/caltechcameratraps/eccv_18_all_images_sm.tar.gz)) and unzip them.
- Process dataset ([OfficeHome](https://drive.google.com/uc?id=1uY0pj7oFsjMxRwaD3Sxy0jgel0fsYXLC), [TerraIncognita]()) referencing [download.py](https://github.com/facebookresearch/DomainBed/blob/main/domainbed/scripts/download.py) in DomainBed (or directly download datasets with it).
- Create directory for log files and change the dataset path (`pacs_path`,`digits_path`, `officehome_path` and `terrainc_path`) and log path (`log_count_path`) in configs/default.py.

## Run experiment

```shell
python algorithms/fedavg/train_pacs.py --test_domain p --fta
python algorithms/fedavg/train_pacs.py --test_domain a --fta
python algorithms/fedavg/train_pacs.py --test_domain c --fta
python algorithms/fedavg/train_pacs.py --test_domain s --fta
python algorithms/fedavg/train_officehome.py --test_domain p --fta
python algorithms/fedavg/train_officehome.py --test_domain a --fta
python algorithms/fedavg/train_officehome.py --test_domain c --fta
python algorithms/fedavg/train_officehome.py --test_domain r --fta
python algorithms/fedavg/train_digits.py --test_domain m --fta
python algorithms/fedavg/train_digits.py --test_domain mm --fta
python algorithms/fedavg/train_digits.py --test_domain s --fta
python algorithms/fedavg/train_digits.py --test_domain sy --fta
python algorithms/fedavg/train_terrainc.py --test_domain 100 --fta
python algorithms/fedavg/train_terrainc.py --test_domain 38 --fta
python algorithms/fedavg/train_terrainc.py --test_domain 43 --fta
python algorithms/fedavg/train_terrainc.py --test_domain 46 --fta
```

## References

- [FedDG-GA](https://github.com/MediaBrain-SJTU/FedDG-GA?tab=readme-ov-file)

## License

- PACS: unknown

- Digits-DG: unknown

- OfficeHome: [Fair Use Notice](https://www.hemanthdv.org/officeHomeDataset.html)

- TerraIncognita: CDLA

- GA: unknown
