# Submission Code for Preference-Guided Diffusion for Multi-Objective Offline Optimization

This repository provides code for the NeurIPS 2025 submission 	
Preference Guided Diffusion for Multi-Objective Offline Optimization. Installation of this repository follows from the offline MOO benchmark by Xue et al 2024. 



## Benchmark Installation (From Xue et al 2024)

For a stable installation and usage, we suggest that you use a machine with ``CUDA version 11.7`` or higher.

### Data Downloading

Our proposed offline collected data can be accessed and downloaded via [Google Drive](https://drive.google.com/drive/folders/1SvU-p4Q5KAjPlHrDJ0VGiU2Te_v9g3rT?usp=drive_link). Please ensure that the data is inside the ``data/`` folder.

### Quick Installation

Run 
```shell
bash install.sh
```
for a quick installation.


### Notice during installation

1. Due to conflict versions among different packages, we design special orders to install packages correctly. Note that conducting ``conda env create -f environment.yml`` may raise some errors during installing Pip dependancy. Do not stop then and keep going on with rest scripts we proposed in ``install.sh``.
2. Due to packages conflicts, we use ``fix_contents.sh`` to solve such conflict bugs by running
    ```shell
    bash fix_contents.sh ${YOUR_PATH_TO_CONDA}/envs/off-moo/lib/python3.8/site-packages/sklearn/cross_decomposition/pls_.py "pinv2" "pinv"
    ```
3. We provide serveral test suites under ``tests/`` folder to check for successful installation.
4. If you meet up with ``libstdc++.so.6: version `GLIBCXX_3.4.29' not found`` issue, since the reasons can be various, we recommend that you refer to [StackOverflow: Where can I find GLIBCXX_3.4.29?](https://stackoverflow.com/questions/65349875/where-can-i-find-glibcxx-3-4-29) or [GitHub: libstdc++.so.6: version `GLIBCXX_3.4.29' not found](https://github.com/pybind/pybind11/discussions/3453) for further advice to solve this issue.
5. We have test different hardware environments, including:
    - Ubuntu 22.04, 4x4090, CUDA 12.3
    - Ubuntu 22.04, 4x4090, CUDA 12.1
    - Ubuntu 22.04, 8xV100(32G), CUDA 12.1
    - Ubuntu 22.04, 1x3090, CUDA 12.0
    - Ubuntu 20.04, 2x3090, CUDA 11.8
    - Ubuntu 20.04, 2xA6000, CUDA 11.8



## Reproducing Results

To reproduce the performance of baseline algorithms reported in our work, you may then run ``multi_head.sh/multiple_models.sh`` inside the ``scripts/`` folder with appropriate name of `tasks` and `training_mode` as required. Also, please ensure that the conda environment ``off-moo`` is activated in the bash session.

To reproduce the results of our work, you may then run ``bash scripts/pgd_moo.sh`` inside the ``scripts/`` folder. Also, please ensure that the conda environment ``off-moo`` is activated in the bash session.