# A-NeSI: Approximate Neurosymbolic Inference

We introduce **Approximate Neurosymbolic Inference (A-NeSI)** a new framework for Probabilistic Neurosymbolic Learning that uses neural networks for scalable approximate inference. A-NeSI 
1. performs approximate inference in polynomial time without relaxing the semantics of probabilistic logics; 
2. is trained using synthetic data generated by the background knowledge; 
3. can generate symbolic explanations of predictions; and 
4. can guarantee the satisfaction of logical constraints at test time. 

For more information, consult the paper listed below.

## Requirements

A-NeSI has the following requirements:

* [Python](https://www.python.org/) - v3.9.15
* [PyTorch](https://pytorch.org/) - v1.12.1
* [TorchVision](https://pytorch.org/vision/stable/index.html) - v0.13.1
* [Weights&Biases](https://wandb.ai/) - v0.13.2

Run the following:

1. Install the dependencies inside a new virtual environment: `bash setup_dependencies.sh`

2. Activate the virtual environment: `conda activate NRM`

3. Install the A-NeSI module: pip install -e .

## Experiments

The experiments are presented in the papers are available in the [anesi/experiments](anesi/experiments) directory. The experiments are organized with Weights&Biases. To reproduce the experiments from the paper, run
```bash
cd anesi/experiments
wandb sweep repeat/test_predict_only.yaml
wandb agent <sweep_id>
```
Note that you will need to update the entity and project parameters of wandb in the sweep files. 

## Paper
[A-NeSI: A Scalable Approximate Method for Probabilistic Neurosymbolic Inference (Arxiv)](https://arxiv.org/abs/2212.12393)
```
@misc{https://doi.org/10.48550/arxiv.2212.12393,
  doi = {10.48550/ARXIV.2212.12393},
  url = {https://arxiv.org/abs/2212.12393},
  author = {van Krieken, Emile and Thanapalasingam, Thiviyan and Tomczak, Jakub M. and van Harmelen, Frank and Teije, Annette ten},
  keywords = {Machine Learning (cs.LG), Artificial Intelligence (cs.AI), Logic in Computer Science (cs.LO), Machine Learning (stat.ML), FOS: Computer and information sciences, FOS: Computer and information sciences},
  title = {A-NeSI: A Scalable Approximate Method for Probabilistic Neurosymbolic Inference},
  publisher = {arXiv},
  year = {2022},
  copyright = {arXiv.org perpetual, non-exclusive license}
}
```