#!/bin/bash
#SBATCH -A euhpc_d09_020
#SBATCH --job-name=e2e_pca_compute
#SBATCH --time=24:00:00
#SBATCH -N 1
#SBATCH --partition=boost_usr_prod
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=8
#SBATCH --output=/leonardo/home/userexternal/lhauzenb/git_repos/eva/slurm_outputs/%j.out


cd /leonardo/home/userexternal/lhauzenb/git_repos/eva/examples/NLU
source /leonardo/home/userexternal/lhauzenb/venv/eva/bin/activate
which python

echo "Executing script: pre_compute_init.py"
python3 pre_compute_init.py \
--model_name_or_path="gpt2-medium" \
--pca_on_acts \
--output_dir="/leonardo_scratch/large/userexternal/lhauzenb/eva_cache" \
--dataset_name e2e_nlg \
--use_all_columns \
--n_components 32 \
--cache_dir="/leonardo_scratch/large/userexternal/lhauzenb/hf_cache/models"


