#!/bin/bash

pip install -e .

# 2D
CMD=(python -u experiments/flow_matching_2d.py
  dataset=C4_arrow
  model=GL2_to_C4_arrow
)

# Group Elements
# CMD=(
#   python -u experiments/flow_matching_angle_to_angle.py
#   dataset=C4_angle
#   model=SO2_to_C4_angle_to_angle
# )

# 3D
# CMD=(
#   python -u experiments/flow_matching_3d.py
#   dataset=Tet_irreg_tet
#   model=SO3_to_Tet_irreg_tet_time_power_dist
# )

cat << EOF
Executing Command

${CMD[*]}

EOF

# WANDB_MODE=offline
CUDA_VISIBLE_DEVICES=0 OMP_NUM_THREADS=4 MPLBACKEND=agg "${CMD[@]}"
