import numpy as np
import robomimic.utils.env_utils as EnvUtils
from robosuite.wrappers import GymWrapper

from .core import Env, wrap_env
from .wrappers.common import TimeStep


class Robosuite(Env):
    def __init__(self, env_meta, seed=42, max_episode_steps=500):
        env_meta["env_kwargs"]["horizon"] = max_episode_steps
        env = EnvUtils.create_env_from_metadata(env_meta, render=False, render_offscreen=False).env
        env.ignore_done = False

        env._max_episode_steps = env.horizon

        env = GymWrapper(env)
        env = wrap_env(env)
        env.seed(seed)
        env.action_space.seed(seed)
        env.observation_space.seed(seed)

        self._env = env
        self._max_episode_steps = self._env.max_episode_steps

    @property
    def observation_space(self):
        return self._env.observation_space

    @property
    def action_space(self):
        return self._env.action_space

    def render(self):
        image = self._env.render("rgb_array")
        assert image is not None
        return image

    def step(self, action: np.ndarray) -> TimeStep:
        observation, reward, done, info = self._env.step(action)

        if self.env._check_success():
            done = True

        return observation, reward, done, info

    def reset(self) -> np.ndarray:
        return self._env.reset()
