## Dependencies

The code (MADDPG baseline) requires Tensorflow 1 which is not available in some recent versions of Python. Setup a virutal environment with Python 3.6, e.g.,
```
virutalenv venv -p python3.6
source venv/bin/activate
```
Now install dependencies using
```
pip install -r requirements.txt
```

## Training

Follow the instructions below to run different approaches comared in the paper. For Rooms environment the training and evaluation scripts are located in `test/rooms` and for the F1/10th environment, they are located in `test/f110_turn`. Change the current working directory accoridingly and create directories to store all results, e.g.,
```
cd test/rooms
mkdir results
mkdir results/ROSAC
mkdir results/AROSAC
mkdir results/NAIVE
mkdir results/DAGGER
mkdir results/MADDPG
```

### Running ROSAC

ROSAC can be run using
```
python rosac.py -n {run_num} -d results/ROSAC -z
```
where `{run_num}` is a number between 1-10 to identify the specific run of the experiment.

### Running AROSAC

AROSAC can be run using
```
python cegrl.py -n {run_num} -d results/AROSAC -z -c
```

### Running DAGGER

DAGGER can be run using
```
python cegrl.py -n {run_num} -d results/DAGGER -c
```

### Running NAIVE

NAIVE can be run using
```
python cegrl.py -n {run_num} -d results/NAIVE
```

### Running MADDPG

MADDPG can be run using
```
python maddpg.py -n {run_num} -d results/MADDPG
```

### Using GPU

If you have a CUDA enabled GPU, use option `-g` in the above commands (except for MADDPG). Optionally, you can also specify a specific GPU to use with option `-v {gpu_num}` if there are multiple GPUs installed.

## Plotting

Once all baselines have been run for N times, use the following command to plot the number of subtasks completed as a function of the number of sample steps when tested against a random adversary.
```
python plot.py -d results -a N -e 0 -v 2
```
Use `-v 3` for number of jumps against MCTS adversary, `-v 4` for completion probability against random adversary or `-v 5` for completion probability against MCTS adversary.

