module load xxx

conda activate mask_model

checkpoint_path=your_ckpt_path_here.ckpt

datasets=(
          "ptb"
          "ag_news"
          "lambada"
          "wikitext2"
          "wikitext103"
          "lm1b-gpt2"
          "scientific_papers_arxiv"
          "scientific_papers_pubmed"
          )

clear

for data in "${datasets[@]}"; do
  echo "$data"
  srun python -u -m main \
    mode=ppl_eval \
    loader.batch_size=16 \
    loader.eval_batch_size=16 \
    loader.eval_global_batch_size=128 \
    data="$data" \
    data.insert_valid_eos=False \
    sampling.steps="$steps" \
    model=small \
    algo=mdlm \
    model.length=1024 \
    eval.checkpoint_path=$checkpoint_path \
    +wandb.offline=true
done
