# Likert-Scale Preference Learning - Code Submission

This repository contains the implementation for the paper "Likert-Scale Preference Learning" submitted to ICLR 2025.

## Overview

Our implementation includes three novel ordinal preference learning methods that effectively utilize fine-grained preference strength information:

- **Ordinal Symmetric**: Treats preference strength as ordinal categories with symmetric thresholds
- **Ordinal Asymmetric**: Handles signed preference information with asymmetric thresholds
- **All-Threshold**: Aggregates losses across all threshold comparisons for comprehensive ordinal learning

## Repository Structure

```
iclr_submission/
├── src/                          # Core source code
│   ├── trainReward.py           # Main training script
│   ├── rewardTrainers.py        # Training loops and loss implementations
│   ├── OrdinalModel.py          # Ordinal regression model
│   ├── RewardModel.py           # Reward model implementations
│   ├── preference_datasets.py   # Dataset loading and preprocessing
│   ├── utils.py                 # Utility functions
│   └── Term.py                  # Term loss utilities
├── config/                       # Hydra configuration files
│   ├── config.yaml              # Main configuration
│   ├── model/                   # Model configurations
│   └── loss/                    # Loss function configurations
├── scripts/                      # Training and evaluation scripts
│   ├── train_example.sh         # Example training commands
│   └── convert_checkpoint.py    # Model conversion for evaluation
├── README.md                    # This file
└── requirements.txt             # Python dependencies
```

## Installation

1. Install Python 3.8+
2. Install dependencies:
```bash
pip install -r requirements.txt
```

## Usage

### Basic Training

The main training script supports all methods described in the paper:

```bash
python src/trainReward.py \
    model=llama \
    datasets=[hs3] \
    loss=ordinal \
    loss.levels=7 \
    loss.offset=3 \
    loss.symmetrize=false \
    exp_name=my_experiment
```

### Key Arguments

- `model`: Base model (`llama`, `mistral`, `zephyr`)
- `datasets`: Training dataset (`[hs2]`, `[hs3]`)
- `loss`: Loss function (`ordinal`, `allThreshold`, `marginBT`, `scaledBT`, `softLabel`)
- `loss.levels`: Number of ordinal levels
- `loss.offset`: Offset for signed labels (asymmetric case)
- `loss.symmetrize`: Use symmetric thresholds (true/false)

### Example Training Commands

See `scripts/train_example.sh` for complete examples of training each method.

#### Ordinal Symmetric (4-level)
```bash
python src/trainReward.py model=llama datasets=[hs2] loss=ordinal \
    loss.levels=4 loss.symmetrize=true exp_name=ordinal_symmetric
```

#### All-Threshold (7-level asymmetric)
```bash
python src/trainReward.py model=zephyr datasets=[hs3] loss=allThreshold \
    loss.levels=7 loss.offset=3 loss.symmetrize=false exp_name=all_threshold
```

#### MarginBT Baseline
```bash
python src/trainReward.py model=mistral datasets=[hs3] loss=marginBT \
    exp_name=marginBT_baseline
```

## Configuration

The codebase uses Hydra for configuration management. Key configuration files:

- `config/config.yaml`: Main training parameters
- `config/model/*.yaml`: Model-specific settings
- `config/loss/*.yaml`: Loss function parameters

## Key Features

### Ordinal Performance Metrics

The implementation tracks specialized metrics for ordinal methods:
- `accuracy_within_0`: Exact prediction accuracy
- `accuracy_within_1`: Accuracy within ±1 level
- `accuracy_within_2`: Accuracy within ±2 levels
- `mean_absolute_error`: Average prediction error

### Distributed Training

Full support for multi-GPU training with FSDP:
- Automatic GPU detection and process spawning
- Mixed precision training (bfloat16)
- Gradient accumulation and clipping

### Reproducibility

- Fixed random seeds for all components
- Deterministic data shuffling
- Configuration logging and checkpointing

## Model Conversion

Convert trained models for evaluation:

```bash
python scripts/convert_checkpoint.py \
    --input_dir /path/to/checkpoint \
    --output_dir /path/to/hf_model \
    --base_model allenai/Llama-3.1-Tulu-3-8B-SFT
```

## Hardware Requirements

- 8 GPUs (H100 or H200 recommended)
- 2048 GB total GPU memory for full experiments
- SSD storage for datasets and checkpoints

## Citation

If you use this code, please cite our paper:

```bibtex
@inproceedings{likert2025,
  title={Likert-Scale Preference Learning},
  author={[Authors]},
  booktitle={International Conference on Learning Representations},
  year={2025}
}
```

## License

This code is released under the MIT License. See LICENSE file for details.

## Contact

For questions about the implementation, please contact [contact information].